/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.forge;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.blf02.forge.BufferPacket;
import net.blf02.vrapi.common.Platform;
import net.blf02.vrapi.common.network.NetworkChannel;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PlatformImpl
implements Platform {
    public static final List<Object> keyMappingsToRegister = new ArrayList<Object>();
    public static final SimpleChannel NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("vrapi", "network")).networkProtocolVersion(() -> "3.0.10+").serverAcceptedVersions(ignored -> true).clientAcceptedVersions(ignored -> true).simpleChannel();

    @Override
    public boolean isClient() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLEnvironment.production;
    }

    @Override
    public void registerKeyBinding(Object keyMapping) {
        keyMappingsToRegister.add(keyMapping);
    }

    @Override
    public <T> void sendToServer(T message, NetworkChannel.NetworkRegistrationData<T> data) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeInt(data.id());
        data.encoder().accept(message, buffer);
        NETWORK.sendToServer((Object)new BufferPacket(buffer));
    }

    @Override
    public <T> void sendToPlayer(ServerPlayer player, T message, NetworkChannel.NetworkRegistrationData<T> data) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeInt(data.id());
        data.encoder().accept(message, buffer);
        NETWORK.send(PacketDistributor.PLAYER.with(() -> player), (Object)new BufferPacket(buffer));
    }

    @Override
    public void registerClientPostTick(Consumer<Player> ticker) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91074_ != null) {
                ticker.accept((Player)Minecraft.m_91087_().f_91074_);
            }
        });
    }

    @Override
    public void registerServerPostTick(Consumer<Player> ticker) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.phase == TickEvent.Phase.END) {
                event.getServer().m_6846_().m_11314_().forEach(ticker);
            }
        });
    }

    @Override
    public void registerClientPlayerQuit(Consumer<Player> quitHandler) {
        MinecraftForge.EVENT_BUS.addListener(event -> quitHandler.accept((Player)event.getPlayer()));
    }

    @Override
    public void registerOnPlayerJoin(Consumer<ServerPlayer> joinHandler) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            Player patt3721$temp = event.getEntity();
            if (patt3721$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt3721$temp;
                joinHandler.accept(sp);
            }
        });
    }

    @Override
    public void registerOnPlayerDisconnect(Consumer<ServerPlayer> disconnectHandler) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            Player patt4059$temp = event.getEntity();
            if (patt4059$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt4059$temp;
                disconnectHandler.accept(sp);
            }
        });
    }
}

