/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mns_compat.main;

import com.mojang.brigadier.CommandDispatcher;
import com.robertx22.mns_compat.commands.DamageWatchStop;
import com.robertx22.mns_compat.commands.DamageWatchToggle;
import java.util.function.Consumer;
import java.util.logging.Logger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="mns_compat")
public class CommonInit {
    public static String ID = "mns_compat";

    public CommonInit() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetupEvent);
        CommonInit.registerForgeEvent(RegisterCommandsEvent.class, event -> {
            DamageWatchToggle.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            DamageWatchStop.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        });
        CommonInit.registerForgeEvent(LivingDamageEvent.class, event -> {
            try {
                if (!event.getEntity().m_9236_().f_46443_ && DamageWatchToggle.onDamaged((Entity)event.getEntity(), event.getSource(), event.getAmount())) return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        Logger log = Logger.getLogger(ID);
        log.info("Mine and Slash Compatibility Addon Loaded.");
        log.info("- Mine and Slash will now work as bonus extra damage, instead of replacing/overriding damage");
    }

    public void commonSetupEvent(FMLCommonSetupEvent event) {
    }

    public static <T extends Event> void registerForgeEvent(Class<T> clazz, Consumer<T> event, EventPriority priority) {
        if (IModBusEvent.class.isAssignableFrom(clazz) || clazz.isAssignableFrom(IModBusEvent.class)) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(priority, event);
        } else {
            MinecraftForge.EVENT_BUS.addListener(priority, event);
        }
    }

    public static <T extends Event> void registerForgeEvent(Class<T> clazz, Consumer<T> event) {
        CommonInit.registerForgeEvent(clazz, event, EventPriority.NORMAL);
    }
}

