/*
 * Decompiled with CFR 0.152.
 */
package io.github.prismwork.emitrades.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import io.github.prismwork.emitrades.EMITradesPlugin;
import io.github.prismwork.emitrades.util.EntityEmiStack;
import io.github.prismwork.emitrades.util.TradeProfile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class VillagerTrade
implements EmiRecipe {
    private final TradeProfile profile;
    private final List<EmiIngredient> inputs;
    private final List<EmiStack> outputs;
    private final List<EmiIngredient> catalysts;
    private final int id;
    private final MutableComponent title;

    public VillagerTrade(TradeProfile profile, int id) {
        this.profile = profile;
        this.inputs = new ArrayList<EmiIngredient>();
        this.outputs = new ArrayList<EmiStack>();
        this.catalysts = profile.villager() != null ? List.of(EntityEmiStack.ofScaled((Entity)profile.villager(), 12.0f)) : List.of();
        this.id = id;
        VillagerProfession internalProf = profile.profession();
        this.title = internalProf.equals((Object)EMITradesPlugin.WANDERING_TRADER_PLACEHOLDER) ? Component.m_237115_((String)"emi.emitrades.placeholder.wandering_trader") : Component.m_237115_((String)("entity.minecraft.villager." + profile.profession().f_35600_().substring(profile.profession().f_35600_().lastIndexOf(":") + 1))).m_130946_(" - ").m_7220_((Component)Component.m_237115_((String)("emi.emitrades.profession.lvl." + profile.level())));
        VillagerTrades.ItemListing offer = profile.offer();
        if (offer instanceof VillagerTrades.EmeraldForItems) {
            VillagerTrades.EmeraldForItems factory = (VillagerTrades.EmeraldForItems)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemLike)factory.f_35651_, (long)factory.f_35652_));
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            this.outputs.add(0, EmiStack.of((ItemLike)Items.f_42616_));
        } else if (offer instanceof VillagerTrades.ItemsForEmeralds) {
            VillagerTrades.ItemsForEmeralds factory = (VillagerTrades.ItemsForEmeralds)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemLike)Items.f_42616_, (long)factory.f_35735_));
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            this.outputs.add(0, EmiStack.of((ItemStack)factory.f_35734_, (long)factory.f_35736_));
        } else if (offer instanceof VillagerTrades.SuspiciousStewForEmerald) {
            VillagerTrades.SuspiciousStewForEmerald factory = (VillagerTrades.SuspiciousStewForEmerald)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemLike)Items.f_42616_, (long)1L));
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            ItemStack stack = new ItemStack((ItemLike)Items.f_42718_, 1);
            SuspiciousStewItem.m_43258_((ItemStack)stack, (MobEffect)factory.f_186308_, (int)factory.f_186309_);
            this.outputs.add(0, EmiStack.of((ItemStack)stack));
        } else if (offer instanceof VillagerTrades.ItemsAndEmeraldsToItems) {
            VillagerTrades.ItemsAndEmeraldsToItems factory = (VillagerTrades.ItemsAndEmeraldsToItems)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemLike)Items.f_42616_, (long)factory.f_35710_));
            this.inputs.add(1, (EmiIngredient)EmiStack.of((ItemStack)factory.f_35708_, (long)factory.f_35709_));
            this.outputs.add(0, EmiStack.of((ItemStack)factory.f_35711_, (long)factory.f_35712_));
        } else if (offer instanceof VillagerTrades.EnchantedItemForEmeralds) {
            VillagerTrades.EnchantedItemForEmeralds factory = (VillagerTrades.EnchantedItemForEmeralds)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemLike)Items.f_42616_, (long)Math.min(factory.f_35688_ + 5, 64)));
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            this.outputs.add(0, EmiStack.of((ItemStack)factory.f_35687_));
        } else if (offer instanceof VillagerTrades.EmeraldsForVillagerTypeItem) {
            VillagerTrades.EmeraldsForVillagerTypeItem factory = (VillagerTrades.EmeraldsForVillagerTypeItem)offer;
            ArrayList stacks = new ArrayList();
            factory.f_35664_.values().forEach(item -> stacks.add(EmiStack.of((ItemLike)item)));
            this.inputs.add(0, (EmiIngredient)new ListEmiIngredient(stacks, (long)factory.f_35665_));
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            this.outputs.add(0, EmiStack.of((ItemLike)Items.f_42616_));
        } else if (offer instanceof VillagerTrades.TippedArrowForItemsAndEmeralds) {
            VillagerTrades.TippedArrowForItemsAndEmeralds factory = (VillagerTrades.TippedArrowForItemsAndEmeralds)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemLike)Items.f_42616_, (long)factory.f_35786_));
            this.inputs.add(1, (EmiIngredient)EmiStack.of((ItemLike)factory.f_35789_, (long)factory.f_35790_));
            this.outputs.add(0, EmiStack.of((ItemStack)factory.f_35784_, (long)factory.f_35785_));
        } else if (offer instanceof VillagerTrades.EnchantBookForEmeralds) {
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemLike)Items.f_42616_, (long)5L));
            this.inputs.add(1, (EmiIngredient)EmiStack.of((ItemLike)Items.f_42517_));
            this.outputs.add(0, EmiStack.of((ItemLike)Items.f_42690_));
        } else if (offer instanceof VillagerTrades.TreasureMapForEmeralds) {
            VillagerTrades.TreasureMapForEmeralds factory = (VillagerTrades.TreasureMapForEmeralds)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemLike)Items.f_42616_, (long)factory.f_35805_));
            this.inputs.add(1, (EmiIngredient)EmiStack.of((ItemLike)Items.f_42522_));
            this.outputs.add(0, EmiStack.of((ItemLike)Items.f_42573_));
        } else if (offer instanceof VillagerTrades.DyedArmorForEmeralds) {
            VillagerTrades.DyedArmorForEmeralds factory = (VillagerTrades.DyedArmorForEmeralds)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemLike)Items.f_42616_, (long)factory.f_35635_));
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            this.outputs.add(0, EmiStack.of((ItemLike)factory.f_35634_));
        } else if (offer instanceof EMITradesPlugin.FakeFactory) {
            EMITradesPlugin.FakeFactory factory = (EMITradesPlugin.FakeFactory)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((ItemStack)factory.first));
            this.inputs.add(1, (EmiIngredient)EmiStack.of((ItemStack)factory.second));
            this.outputs.add(0, EmiStack.of((ItemStack)factory.sell));
        } else {
            this.inputs.add(0, (EmiIngredient)EmiStack.EMPTY);
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            this.outputs.add(0, EmiStack.EMPTY);
        }
    }

    public List<EmiIngredient> getCatalysts() {
        return this.catalysts;
    }

    public EmiRecipeCategory getCategory() {
        return EMITradesPlugin.VILLAGER_TRADES;
    }

    @Nullable
    public ResourceLocation getId() {
        return new ResourceLocation("emitrades", "villager_trades/" + this.profile.profession().f_35600_().substring(this.profile.profession().f_35600_().lastIndexOf(":") + 1) + "_" + this.id);
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        Font textRenderer = Minecraft.m_91087_().f_91062_;
        int extraWidth = this.catalysts.isEmpty() ? 0 : 21;
        return this.catalysts.isEmpty() || !EMITradesPlugin.CONFIG.enable3DVillagerModelInRecipes ? Math.max(86, textRenderer.m_92852_((FormattedText)this.title) + 2) : Math.max(extraWidth + 85, extraWidth + textRenderer.m_92852_((FormattedText)this.title));
    }

    public int getDisplayHeight() {
        return 28;
    }

    public void addWidgets(WidgetHolder widgets) {
        Font textRenderer = Minecraft.m_91087_().f_91062_;
        if (this.catalysts.isEmpty() || !EMITradesPlugin.CONFIG.enable3DVillagerModelInRecipes) {
            widgets.addText((Component)this.title, (this.getDisplayWidth() - textRenderer.m_92852_((FormattedText)this.title)) / 2, 0, 0xFFFFFF, true);
            widgets.addSlot(this.inputs.get(0), this.getDisplayWidth() / 2 - 42, 10);
            widgets.addSlot(this.inputs.get(1), this.getDisplayWidth() / 2 - 22, 10);
            widgets.addTexture(EmiTexture.EMPTY_ARROW, this.getDisplayWidth() / 2 - 3, 10);
            SlotWidget outputSlot = new SlotWidget((EmiIngredient)this.outputs.get(0), this.getDisplayWidth() / 2 + 22, 10).recipeContext((EmiRecipe)this);
            this.wrapOutput(widgets, outputSlot);
        } else {
            SlotWidget villagerSlot = new SlotWidget(this.catalysts.get(0), 1, 6).drawBack(false);
            AbstractVillager abstractVillager = this.profile.villager();
            if (abstractVillager instanceof Villager) {
                Villager villager = (Villager)abstractVillager;
                villagerSlot.appendTooltip((Component)Component.m_237115_((String)("emi.emitrades.profession.lvl." + villager.m_7141_().m_35576_())).m_130940_(ChatFormatting.YELLOW));
            }
            widgets.add((Widget)villagerSlot);
            widgets.addText((Component)this.title, 21, 0, 0xFFFFFF, true);
            widgets.addSlot(this.inputs.get(0), 21, 10);
            widgets.addSlot(this.inputs.get(1), 41, 10);
            widgets.addTexture(EmiTexture.EMPTY_ARROW, 60, 10);
            SlotWidget outputSlot = new SlotWidget((EmiIngredient)this.outputs.get(0), 85, 10).recipeContext((EmiRecipe)this);
            this.wrapOutput(widgets, outputSlot);
        }
    }

    private void wrapOutput(WidgetHolder widgets, SlotWidget outputSlot) {
        List<Enchantment> list;
        if (this.profile.offer() instanceof VillagerTrades.DyedArmorForEmeralds) {
            outputSlot = outputSlot.appendTooltip((Component)Component.m_237115_((String)"emi.emitrades.random_colored").m_130940_(ChatFormatting.YELLOW));
        } else if (this.profile.offer() instanceof VillagerTrades.TippedArrowForItemsAndEmeralds || this.profile.offer() instanceof VillagerTrades.SuspiciousStewForEmerald) {
            outputSlot = outputSlot.appendTooltip((Component)Component.m_237115_((String)"emi.emitrades.random_effect").m_130940_(ChatFormatting.YELLOW));
        } else if (this.profile.offer() instanceof VillagerTrades.TreasureMapForEmeralds) {
            outputSlot = outputSlot.appendTooltip((Component)Component.m_237115_((String)"emi.emitrades.random_structure").m_130940_(ChatFormatting.YELLOW));
        } else if ((this.profile.offer() instanceof VillagerTrades.EnchantBookForEmeralds || this.profile.offer() instanceof VillagerTrades.EnchantedItemForEmeralds) && !(list = BuiltInRegistries.f_256876_.m_123024_().filter(Enchantment::m_6594_).toList()).isEmpty()) {
            outputSlot = outputSlot.appendTooltip((Component)Component.m_237115_((String)"emi.emitrades.enchantments.possible").m_130940_(ChatFormatting.AQUA));
            for (Enchantment enchantment : list) {
                outputSlot = outputSlot.appendTooltip((Component)Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237115_((String)enchantment.m_44704_())).m_130940_(ChatFormatting.GRAY));
            }
        }
        widgets.add((Widget)outputSlot);
    }
}

