/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.command;

import com.connectivity.command.IMCCommand;
import com.connectivity.command.IMCOPCommand;
import com.connectivity.networkstats.NetworkStatGatherer;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;

public class CommandNetworkStatsPrintPacket
implements IMCOPCommand {
    public static final String NETWORKSTATS_PRINT_PACKET_COMMAND = "/connectivity printpacket %s";

    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        NetworkStatGatherer.reportStatsSummary(source, 5, 0);
        return 0;
    }

    @Override
    public String getName() {
        return "printpacket";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("name", StringArgumentType.word()).executes(this::executeWithMinutes));
    }

    private int executeWithMinutes(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        NetworkStatGatherer.printPacketsFittingName(source, StringArgumentType.getString(context, (String)"name"));
        return 0;
    }
}

