/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io.legacycompat;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.CompoundTagBuilder;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.EntityNBTCompatibilityHandler;
import com.sk89q.worldedit.internal.helper.MCDirections;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.entity.EntityType;

public class Pre13HangingCompatibilityHandler
implements EntityNBTCompatibilityHandler {
    @Override
    public boolean isAffectedEntity(EntityType type, CompoundTag tag) {
        if (!type.getId().startsWith("minecraft:")) {
            return false;
        }
        boolean hasLegacyDirection = tag.containsKey("Dir") || tag.containsKey("Direction");
        boolean hasFacing = tag.containsKey("Facing");
        return hasLegacyDirection || hasFacing;
    }

    @Override
    public CompoundTag updateNBT(EntityType type, CompoundTag tag) {
        Direction newDirection;
        boolean hasLegacyDir = tag.containsKey("Dir");
        boolean hasLegacyDirection = tag.containsKey("Direction");
        boolean hasPre113Facing = tag.containsKey("Facing");
        if (hasLegacyDir) {
            newDirection = MCDirections.fromPre13Hanging(MCDirections.fromLegacyHanging((byte)tag.asInt("Dir")));
        } else if (hasLegacyDirection) {
            newDirection = MCDirections.fromPre13Hanging(tag.asInt("Direction"));
        } else if (hasPre113Facing) {
            newDirection = MCDirections.fromPre13Hanging(tag.asInt("Facing"));
        } else {
            return tag;
        }
        byte hangingByte = (byte)MCDirections.toHanging(newDirection);
        CompoundTagBuilder builder = tag.createBuilder();
        builder.putByte("Facing", hangingByte);
        return builder.build();
    }
}

