/*
 * Decompiled with CFR 0.152.
 */
package com.chirptheboy.disenchanting.capabilities;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class ItemStackHandlerWrapper
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    public static final String NBT_INPUT = "Input";
    public static final String NBT_OUTPUT = "Output";
    protected final ItemStackHandler input;
    protected final ItemStackHandler output;

    public ItemStackHandlerWrapper(ItemStackHandler input, ItemStackHandler output) {
        this.input = input;
        this.output = output;
    }

    protected <T> T withHandler(int externalSlot, HandlerCallback<T> callback) {
        int numInputSlots = this.input.getSlots();
        boolean isInput = externalSlot < numInputSlots;
        int internalSlot = isInput ? externalSlot : externalSlot - numInputSlots;
        ItemStackHandler handler = isInput ? this.input : this.output;
        return callback.apply(handler, internalSlot, isInput);
    }

    protected void withHandlerV(int slot, HandlerCallbackVoid func) {
        this.withHandler(slot, (h, s, isInput) -> {
            func.apply(h, s, isInput);
            return false;
        });
    }

    public int getSlots() {
        return this.input.getSlots() + this.output.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.withHandler(slot, (h, s, isInput) -> h.getStackInSlot(s));
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.withHandler(slot, (h, s, isInput) -> isInput ? h.insertItem(s, stack, simulate) : stack);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.withHandler(slot, (h, s, isInput) -> isInput ? ItemStack.f_41583_ : ItemStack.f_41583_);
    }

    public int getSlotLimit(int slot) {
        return this.withHandler(slot, (h, s, isInput) -> h.getSlotLimit(s));
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.withHandler(slot, (h, s, isInput) -> isInput && h.isItemValid(s, stack));
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.withHandlerV(slot, (h, s, isInput) -> h.setStackInSlot(s, stack));
    }

    public CompoundTag serializeNBT() {
        CompoundTag cmp = new CompoundTag();
        cmp.m_128365_(NBT_INPUT, (Tag)this.input.serializeNBT());
        cmp.m_128365_(NBT_OUTPUT, (Tag)this.output.serializeNBT());
        return cmp;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.input.deserializeNBT(nbt.m_128469_(NBT_INPUT));
        this.output.deserializeNBT(nbt.m_128469_(NBT_OUTPUT));
    }

    @FunctionalInterface
    protected static interface HandlerCallback<T> {
        public T apply(ItemStackHandler var1, int var2, boolean var3);
    }

    @FunctionalInterface
    protected static interface HandlerCallbackVoid {
        public void apply(ItemStackHandler var1, int var2, boolean var3);
    }
}

