/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.infinitygolem.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.mcreator.infinitygolem.entity.MagmaBlastEntity;
import net.mcreator.infinitygolem.procedures.CalculateViewVectorXProcedure;
import net.mcreator.infinitygolem.procedures.CalculateViewVectorYProcedure;
import net.mcreator.infinitygolem.procedures.CalculateViewVectorZProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class VisualEffectManagerProcedure {
    private static BufferBuilder bufferBuilder = null;
    private static VertexBuffer vertexBuffer = null;
    private static VertexFormat.Mode mode = null;
    private static VertexFormat format = null;
    private static PoseStack poseStack = null;
    private static Matrix4f projectionMatrix = null;
    private static boolean worldCoordinate = true;
    private static Vec3 offset = Vec3.f_82478_;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static void add(double x, double y, double z, int color) {
        VisualEffectManagerProcedure.add(x, y, z, 0.0f, 0.0f, color);
    }

    private static void add(double x, double y, double z, float u, float v, int color) {
        if (bufferBuilder == null || !bufferBuilder.m_85732_()) {
            return;
        }
        if (format == DefaultVertexFormat.f_85815_) {
            bufferBuilder.m_5483_(x, y, z).m_193479_(color).m_5752_();
        } else if (format == DefaultVertexFormat.f_85819_) {
            bufferBuilder.m_5483_(x, y, z).m_7421_(u, v).m_193479_(color).m_5752_();
        }
    }

    private static boolean begin(VertexFormat.Mode mode, VertexFormat format, boolean update) {
        if (bufferBuilder == null || !bufferBuilder.m_85732_()) {
            if (update) {
                VisualEffectManagerProcedure.clear();
            }
            if (vertexBuffer == null) {
                if (format == DefaultVertexFormat.f_85815_) {
                    VisualEffectManagerProcedure.mode = mode;
                    VisualEffectManagerProcedure.format = format;
                    bufferBuilder = Tesselator.m_85913_().m_85915_();
                    bufferBuilder.m_166779_(mode, DefaultVertexFormat.f_85815_);
                    return true;
                }
                if (format == DefaultVertexFormat.f_85819_) {
                    VisualEffectManagerProcedure.mode = mode;
                    VisualEffectManagerProcedure.format = format;
                    bufferBuilder = Tesselator.m_85913_().m_85915_();
                    bufferBuilder.m_166779_(mode, DefaultVertexFormat.f_85819_);
                    return true;
                }
            }
        }
        return false;
    }

    private static void clear() {
        if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
    }

    private static void end() {
        if (bufferBuilder == null || !bufferBuilder.m_85732_()) {
            return;
        }
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        vertexBuffer.m_85921_();
        vertexBuffer.m_231221_(bufferBuilder.m_231175_());
        VertexBuffer.m_85931_();
    }

    private static void offset(double x, double y, double z) {
        offset = new Vec3(x, y, z);
    }

    private static void release() {
        targetStage = 0;
    }

    private static VertexBuffer shape() {
        return vertexBuffer;
    }

    private static void system(boolean worldCoordinate) {
        VisualEffectManagerProcedure.worldCoordinate = worldCoordinate;
    }

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            VisualEffectManagerProcedure.targetStage = targetStage;
            return true;
        }
        return false;
    }

    private static void renderShape(VertexBuffer vertexBuffer, double x, double y, double z, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        float k;
        float j;
        float i;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (poseStack == null || projectionMatrix == null) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        if (worldCoordinate) {
            Vec3 pos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            i = (float)(x - pos.m_7096_());
            j = (float)(y - pos.m_7098_());
            k = (float)(z - pos.m_7094_());
        } else {
            i = (float)x;
            j = (float)y;
            k = (float)z;
        }
        poseStack.m_85836_();
        poseStack.m_252880_(i, j, k);
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(xScale, yScale, zScale);
        poseStack.m_85837_(offset.m_7096_(), offset.m_7098_(), offset.m_7094_());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.m_85921_();
        vertexBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, vertexBuffer.m_166892_().hasUV(0) ? GameRenderer.m_172820_() : GameRenderer.m_172811_());
        VertexBuffer.m_85931_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            currentStage = 1;
            RenderSystem.depthMask((boolean)false);
            VisualEffectManagerProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            currentStage = 2;
            RenderSystem.depthMask((boolean)true);
            VisualEffectManagerProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        }
    }

    private static void renderShapes(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        Entity entity = minecraft.f_91063_.m_109153_().m_90592_();
        if (level != null && entity != null) {
            poseStack = event.getPoseStack();
            projectionMatrix = event.getProjectionMatrix();
            Vec3 pos = entity.m_20318_(event.getPartialTick());
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            VisualEffectManagerProcedure.execute((Event)event, (LevelAccessor)level);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    public static void execute(LevelAccessor world) {
        VisualEffectManagerProcedure.execute(null, world);
    }

    private static void execute(@Nullable Event event, LevelAccessor world) {
        Object owner = null;
        double initialYaw = 0.0;
        double distance = 0.0;
        double initianlPitch = 0.0;
        double z1 = 0.0;
        double y1 = 0.0;
        double x1 = 0.0;
        double num = 0.0;
        if (world instanceof ClientLevel) {
            for (Entity entityiterator : ((ClientLevel)world).m_104735_()) {
                int n;
                MagmaBlastEntity _datEntI;
                if (!(entityiterator instanceof MagmaBlastEntity) || !VisualEffectManagerProcedure.target(2)) continue;
                distance = 4.0;
                RenderSystem.disableCull();
                VisualEffectManagerProcedure.system(true);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("minecraft:textures/block/magma.png"));
                x1 = 255.0;
                if (entityiterator instanceof MagmaBlastEntity) {
                    _datEntI = (MagmaBlastEntity)entityiterator;
                    v0 = ((Integer)_datEntI.m_20088_().m_135370_(MagmaBlastEntity.DATA_maxLifeTime)).intValue();
                } else {
                    v0 = num = 0.0;
                }
                if (entityiterator instanceof MagmaBlastEntity) {
                    _datEntI = (MagmaBlastEntity)entityiterator;
                    n = (Integer)_datEntI.m_20088_().m_135370_(MagmaBlastEntity.DATA_lifeTime);
                } else {
                    n = 0;
                }
                num = (double)n / num;
                y1 = x1 * (1.0 - num);
                if (VisualEffectManagerProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_, true)) {
                    VisualEffectManagerProcedure.add(0.7, 0.0, -0.7, 0.0f, 0.0f, (int)x1 << 24 | (int)y1 << 16 | (int)y1 << 8 | (int)y1);
                    VisualEffectManagerProcedure.add(0.7, 0.0, 0.7, 0.0f, 1.0f, (int)x1 << 24 | (int)y1 << 16 | (int)y1 << 8 | (int)y1);
                    VisualEffectManagerProcedure.add(0.7, distance, 0.7, (float)distance, 1.0f, (int)x1 << 24 | (int)y1 << 16 | (int)y1 << 8 | (int)y1);
                    VisualEffectManagerProcedure.add(0.7, distance, -0.7, (float)distance, 0.0f, (int)x1 << 24 | (int)y1 << 16 | (int)y1 << 8 | (int)y1);
                    VisualEffectManagerProcedure.add(-0.7, 0.0, -0.7, 0.0f, 0.0f, (int)x1 << 24 | (int)y1 << 16 | (int)y1 << 8 | (int)y1);
                    VisualEffectManagerProcedure.add(-0.7, 0.0, 0.7, 0.0f, 1.0f, (int)x1 << 24 | (int)y1 << 16 | (int)y1 << 8 | (int)y1);
                    VisualEffectManagerProcedure.add(-0.7, distance, 0.7, (float)distance, 1.0f, (int)x1 << 24 | (int)y1 << 16 | (int)y1 << 8 | (int)y1);
                    VisualEffectManagerProcedure.add(-0.7, distance, -0.7, (float)distance, 0.0f, (int)x1 << 24 | (int)y1 << 16 | (int)y1 << 8 | (int)y1);
                    VisualEffectManagerProcedure.add(-0.7, 0.0, 0.7, 0.0f, 0.0f, (int)x1 << 24 | (int)y1 << 16 | (int)y1 << 8 | (int)y1);
                    VisualEffectManagerProcedure.add(0.7, 0.0, 0.7, 0.0f, 1.0f, (int)x1 << 24 | (int)y1 << 16 | (int)y1 << 8 | (int)y1);
                    VisualEffectManagerProcedure.add(0.7, distance, 0.7, (float)distance, 1.0f, (int)x1 << 24 | (int)y1 << 16 | (int)y1 << 8 | (int)y1);
                    VisualEffectManagerProcedure.add(-0.7, distance, 0.7, (float)distance, 0.0f, (int)x1 << 24 | (int)y1 << 16 | (int)y1 << 8 | (int)y1);
                    VisualEffectManagerProcedure.add(-0.7, 0.0, -0.7, 0.0f, 0.0f, (int)x1 << 24 | (int)y1 << 16 | (int)y1 << 8 | (int)y1);
                    VisualEffectManagerProcedure.add(0.7, 0.0, -0.7, 0.0f, 1.0f, (int)x1 << 24 | (int)y1 << 16 | (int)y1 << 8 | (int)y1);
                    VisualEffectManagerProcedure.add(0.7, distance, -0.7, (float)distance, 1.0f, (int)x1 << 24 | (int)y1 << 16 | (int)y1 << 8 | (int)y1);
                    VisualEffectManagerProcedure.add(-0.7, distance, -0.7, (float)distance, 0.0f, (int)x1 << 24 | (int)y1 << 16 | (int)y1 << 8 | (int)y1);
                    VisualEffectManagerProcedure.end();
                }
                x1 = 0.0;
                y1 = 0.0;
                z1 = 0.0;
                for (int index0 = 0; index0 < 10; ++index0) {
                    initialYaw = Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)-30, (int)30);
                    initianlPitch = Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)-120, (int)-60);
                    VisualEffectManagerProcedure.renderShape(VisualEffectManagerProcedure.shape(), entityiterator.m_20185_() + x1, entityiterator.m_20186_() + y1, entityiterator.m_20189_() + z1, (float)initialYaw, (float)(initianlPitch + 90.0), 0.0f, (float)(1.0 - num), 1.0f, (float)(1.0 - num), -1);
                    x1 += CalculateViewVectorXProcedure.execute(initianlPitch, initialYaw) * distance;
                    y1 += CalculateViewVectorYProcedure.execute(initianlPitch, initialYaw) * distance;
                    z1 += CalculateViewVectorZProcedure.execute(initianlPitch, initialYaw) * distance;
                }
                RenderSystem.enableCull();
                VisualEffectManagerProcedure.release();
            }
        }
    }
}

