/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entityprotector.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.poe.entityprotector.config.ConfigurationManager;
import net.poe.entityprotector.config.EntityConfig;
import net.poe.entityprotector.config.GlobalNeutralConfig;
import net.poe.entityprotector.handlers.AggroManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="entityprotector")
public class DamageHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean debugMode = false;
    private static int tickCounter = 0;
    private static final Map<UUID, Set<UUID>> playerAttackHistory = new HashMap<UUID, Set<UUID>>();

    public static void setDebugMode(boolean debug) {
        debugMode = debug;
        LOGGER.info("Debug mode {}", (Object)(debug ? "enabled" : "disabled"));
    }

    public static void toggleDebugMode() {
        debugMode = !debugMode;
        LOGGER.info("EntityProtector debug mode: {}", (Object)(debugMode ? "ENABLED" : "DISABLED"));
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    private static void recordPlayerAttack(Player player, LivingEntity entity) {
        UUID playerId = player.m_20148_();
        UUID entityId = entity.m_20148_();
        playerAttackHistory.computeIfAbsent(playerId, k -> new HashSet()).add(entityId);
        if (debugMode) {
            LOGGER.info("DEBUG: Recorded player {} attacking entity {} (UUID: {})", (Object)player.m_7755_().getString(), (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()), (Object)entityId);
        }
    }

    private static boolean hasPlayerAttackedEntity(Player player, LivingEntity entity) {
        boolean hasAttacked;
        UUID playerId = player.m_20148_();
        UUID entityId = entity.m_20148_();
        Set<UUID> attackedEntities = playerAttackHistory.get(playerId);
        boolean bl = hasAttacked = attackedEntities != null && attackedEntities.contains(entityId);
        if (debugMode && !hasAttacked) {
            LOGGER.info("DEBUG: Player {} has NOT attacked entity {} (UUID: {})", (Object)player.m_7755_().getString(), (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()), (Object)entityId);
        }
        return hasAttacked;
    }

    private static boolean isTamedOrSummoned(Entity entity) {
        if (entity instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)entity;
            return tamable.m_21824_();
        }
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)entity;
            return ownable.m_269323_() != null;
        }
        return false;
    }

    private static Player getOwner(Entity entity) {
        TamableAnimal tamable;
        if (entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_21824_()) {
            LivingEntity owner = tamable.m_269323_();
            return owner instanceof Player ? (Player)owner : null;
        }
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)entity;
            LivingEntity owner = ownable.m_269323_();
            return owner instanceof Player ? (Player)owner : null;
        }
        return null;
    }

    private static boolean shouldManageEntity(String entityId) {
        if (ConfigurationManager.hasConfig(entityId)) {
            return true;
        }
        GlobalNeutralConfig globalConfig = ConfigurationManager.getGlobalNeutralConfig();
        return globalConfig.isEnabled() && !globalConfig.getExcludeEntitys().contains(entityId);
    }

    private static EntityConfig getEffectiveConfig(String entityId) {
        EntityConfig individualConfig = ConfigurationManager.getEntityConfig(entityId);
        if (individualConfig != null) {
            return individualConfig;
        }
        GlobalNeutralConfig globalConfig = ConfigurationManager.getGlobalNeutralConfig();
        if (globalConfig.isEnabled() && !globalConfig.getExcludeEntitys().contains(entityId)) {
            EntityConfig tempConfig = new EntityConfig(entityId);
            tempConfig.setTakeNormalDamage(globalConfig.isTakeNormalDamage());
            tempConfig.setTakeMobDamage(globalConfig.isTakeMobDamage());
            tempConfig.setTakeGenericSpellDamage(globalConfig.isTakeGenericSpellDamage());
            tempConfig.setTakeMineSlashSpellDamage(globalConfig.isTakeMineSlashSpellDamage());
            tempConfig.setTakeIronSpellDamage(globalConfig.isTakeIronSpellDamage());
            tempConfig.setCanDamagePlayer(globalConfig.isCanDamagePlayer());
            tempConfig.setCancelAggroTime(globalConfig.getCancelAggroTime());
            tempConfig.setNeutralUntilAttacked(globalConfig.isNeutralUntilAttacked());
            return tempConfig;
        }
        return null;
    }

    private static boolean isValidTargetForTamedMob(Entity tamedEntity, LivingEntity target) {
        Mob mob;
        Player owner = DamageHandler.getOwner(tamedEntity);
        if (owner == null) {
            return false;
        }
        if (target.m_21214_() == owner) {
            return true;
        }
        if (owner.m_21214_() == target) {
            return true;
        }
        if (target instanceof Mob && (mob = (Mob)target).m_5448_() == owner) {
            return true;
        }
        return owner.m_21188_() == target;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity entity = event.getEntity();
        LivingEntity newTarget = event.getNewTarget();
        if (newTarget == null || !(newTarget instanceof Player)) {
            return;
        }
        Player player = (Player)newTarget;
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId == null) {
            return;
        }
        String entityIdStr = entityId.toString();
        if (debugMode) {
            LOGGER.info("DEBUG: Entity {} attempting to target player {}", (Object)entityIdStr, (Object)player.m_7755_().getString());
            LOGGER.info("DEBUG: Global config enabled: {}, Entity excluded: {}", (Object)ConfigurationManager.getGlobalNeutralConfig().isEnabled(), (Object)ConfigurationManager.getGlobalNeutralConfig().getExcludeEntitys().contains(entityIdStr));
        }
        if (!DamageHandler.shouldManageEntity(entityIdStr)) {
            if (debugMode) {
                LOGGER.info("DEBUG: Entity {} not managed by protection system, allowing normal targeting", (Object)entityIdStr);
            }
            return;
        }
        EntityConfig effectiveConfig = DamageHandler.getEffectiveConfig(entityIdStr);
        if (effectiveConfig == null) {
            return;
        }
        if (debugMode) {
            LOGGER.info("DEBUG: Entity {} is managed - neutralUntilAttacked: {}, canDamagePlayer: {}", (Object)entityIdStr, (Object)effectiveConfig.isNeutralUntilAttacked(), (Object)effectiveConfig.isCanDamagePlayer());
        }
        if (!effectiveConfig.isCanDamagePlayer()) {
            if (debugMode) {
                LOGGER.info("DEBUG: Prevented entity {} from targeting player {} (canDamagePlayer = false)", (Object)entityIdStr, (Object)player.m_7755_().getString());
            }
            event.setCanceled(true);
            return;
        }
        if (effectiveConfig.isNeutralUntilAttacked()) {
            if (!DamageHandler.hasPlayerAttackedEntity(player, entity)) {
                if (debugMode) {
                    LOGGER.info("DEBUG: Prevented neutral entity {} (UUID: {}) from targeting player {} (player hasn't attacked this specific entity yet)", (Object)entityIdStr, (Object)entity.m_20148_(), (Object)player.m_7755_().getString());
                }
                event.setCanceled(true);
                return;
            }
            if (debugMode) {
                LOGGER.info("DEBUG: Allowing neutral entity {} (UUID: {}) to target player {} (player attacked this entity first)", (Object)entityIdStr, (Object)entity.m_20148_(), (Object)player.m_7755_().getString());
            }
        }
        if (DamageHandler.shouldUseWolfLikeAI((Entity)entity)) {
            String targetIdStr;
            if (!DamageHandler.isValidTargetForTamedMob((Entity)entity, newTarget)) {
                if (debugMode) {
                    LOGGER.info("DEBUG: Prevented tamed/summoned entity {} from targeting {} (no valid reason - wolf-like behavior)", (Object)entityIdStr, (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)newTarget.m_6095_()));
                }
                event.setCanceled(true);
                return;
            }
            ResourceLocation targetId = ForgeRegistries.ENTITY_TYPES.getKey((Object)newTarget.m_6095_());
            if (targetId != null && DamageHandler.shouldManageEntity(targetIdStr = targetId.toString())) {
                if (debugMode) {
                    LOGGER.info("DEBUG: Prevented tamed/summoned entity {} from targeting protected entity {}", (Object)entityIdStr, (Object)targetIdStr);
                }
                event.setCanceled(true);
                return;
            }
        }
        if (debugMode) {
            LOGGER.info("DEBUG: Allowing entity {} to target player {} (all checks passed)", (Object)entityIdStr, (Object)player.m_7755_().getString());
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++tickCounter < 5) {
            return;
        }
        tickCounter = 0;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        server.m_129785_().forEach(level -> level.m_8583_().forEach(entity -> {
            if (!(entity instanceof Mob)) {
                return;
            }
            Mob mob = (Mob)entity;
            LivingEntity target = mob.m_5448_();
            if (target == null || !(target instanceof Player)) {
                return;
            }
            Player player = (Player)target;
            ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
            if (entityId == null) {
                return;
            }
            String entityIdStr = entityId.toString();
            if (!DamageHandler.shouldManageEntity(entityIdStr)) {
                return;
            }
            EntityConfig effectiveConfig = DamageHandler.getEffectiveConfig(entityIdStr);
            if (effectiveConfig == null) {
                return;
            }
            if (!effectiveConfig.isCanDamagePlayer()) {
                if (debugMode) {
                    LOGGER.info("DEBUG: [TICK] Prevented entity {} from targeting player {} (canDamagePlayer = false)", (Object)entityIdStr, (Object)player.m_7755_().getString());
                }
                mob.m_6710_(null);
                AggroManager.cancelAggroImmediately((LivingEntity)mob);
                return;
            }
            if (effectiveConfig.isNeutralUntilAttacked() && !DamageHandler.hasPlayerAttackedEntity(player, (LivingEntity)mob)) {
                if (debugMode) {
                    LOGGER.info("DEBUG: [TICK] Prevented neutral entity {} (UUID: {}) from targeting player {} (player hasn't attacked this specific entity yet)", (Object)entityIdStr, (Object)mob.m_20148_(), (Object)player.m_7755_().getString());
                }
                mob.m_6710_(null);
                AggroManager.cancelAggroImmediately((LivingEntity)mob);
                if (effectiveConfig.getCancelAggroTime() > 0) {
                    AggroManager.scheduleAggroCancellation((LivingEntity)mob, (Entity)player, effectiveConfig.getCancelAggroTime() * 20);
                }
                return;
            }
        }));
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        Player player;
        Entity source = event.getSource().m_7639_();
        LivingEntity target = event.getEntity();
        DamageSource damageSource = event.getSource();
        if (!(target instanceof LivingEntity)) {
            return;
        }
        ResourceLocation targetId = ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_());
        if (targetId == null) {
            return;
        }
        String targetIdStr = targetId.toString();
        if (!DamageHandler.shouldManageEntity(targetIdStr)) {
            return;
        }
        EntityConfig targetConfig = DamageHandler.getEffectiveConfig(targetIdStr);
        if (targetConfig == null) {
            return;
        }
        if (debugMode) {
            LOGGER.info("DEBUG: Damage event - Source: {}, Target: {}, DamageType: {}", source != null ? ForgeRegistries.ENTITY_TYPES.getKey((Object)source.m_6095_()) : "null", (Object)targetIdStr, (Object)damageSource.m_19385_());
        }
        if (DamageHandler.isSpellDamage(damageSource) && !DamageHandler.shouldTakeSpellDamage(targetConfig, damageSource)) {
            if (debugMode) {
                LOGGER.info("DEBUG: Cancelled spell damage on protected entity: {}", (Object)targetIdStr);
            }
            event.setCanceled(true);
            DamageHandler.scheduleAggroCancellationIfNeeded(source, (Entity)target, targetConfig);
            return;
        }
        if (source == null) {
            return;
        }
        if (source instanceof Player) {
            player = (Player)source;
            if (!ConfigurationManager.shouldTakeDamage(targetIdStr, "normal")) {
                if (debugMode) {
                    LOGGER.info("DEBUG: Cancelled player damage on protected entity: {}", (Object)targetIdStr);
                }
                event.setCanceled(true);
                DamageHandler.scheduleAggroCancellationIfNeeded(source, (Entity)target, targetConfig);
                return;
            }
        }
        if (source instanceof Player) {
            player = (Player)source;
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = target;
                DamageHandler.recordPlayerAttack(player, livingTarget);
            }
        }
    }

    private static boolean shouldUseWolfLikeAI(Entity entity) {
        if (!DamageHandler.isTamedOrSummoned(entity)) {
            return false;
        }
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString();
        return ConfigurationManager.shouldUseWolfLikeAI(entityId);
    }

    private static void scheduleAggroCancellationIfNeeded(Entity source, Entity target, EntityConfig targetConfig) {
        if (targetConfig.getCancelAggroTime() <= 0) {
            return;
        }
        if (source != null && DamageHandler.shouldUseWolfLikeAI(source)) {
            AggroManager.scheduleAggroCancellation((LivingEntity)source, null, targetConfig.getCancelAggroTime() * 20);
        } else if (source instanceof Player) {
            Player player = (Player)source;
            AggroManager.scheduleAggroCancellation((LivingEntity)target, (Entity)player, targetConfig.getCancelAggroTime() * 20);
        }
    }

    private static boolean isSpellDamage(DamageSource damageSource) {
        String damageType = damageSource.m_19385_();
        return damageType.contains("spell") || damageType.contains("magic") || damageSource.toString().toLowerCase().contains("spell");
    }

    private static boolean shouldTakeSpellDamage(EntityConfig config, DamageSource damageSource) {
        String damageType = damageSource.m_19385_().toLowerCase();
        if (damageType.contains("generic") && damageType.contains("spell")) {
            return config.isTakeGenericSpellDamage();
        }
        if (damageType.contains("mine") && damageType.contains("slash")) {
            return config.isTakeMineSlashSpellDamage();
        }
        if (damageType.contains("iron") && damageType.contains("spell")) {
            return config.isTakeIronSpellDamage();
        }
        return true;
    }
}

