/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entityprotector.handlers;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.poe.entityprotector.config.ConfigurationManager;
import net.poe.entityprotector.handlers.DamageHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="entityprotector")
public class AggroManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<UUID, AggroData> scheduledAggroCancellations = new HashMap<UUID, AggroData>();
    private static final Map<UUID, Integer> peacefulModeSchedule = new HashMap<UUID, Integer>();

    public static void debugEntityCheck(LivingEntity entity, String context) {
        if (entity == null) {
            return;
        }
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId == null) {
            return;
        }
        String entityIdStr = entityId.toString();
        boolean hasConfig = ConfigurationManager.hasConfig(entityIdStr);
        boolean isTamed = AggroManager.isTamedOrSummoned(entity);
        boolean isGlobalEnabled = ConfigurationManager.getGlobalNeutralConfig().isEnabled();
        boolean isExcluded = ConfigurationManager.isEntityExcludedFromGlobal(entityIdStr);
        boolean shouldManage = AggroManager.shouldManageEntity(entityIdStr);
        if (DamageHandler.isDebugMode()) {
            LOGGER.info("DEBUG [{}]: Entity {} - HasConfig: {}, IsTamed: {}, GlobalEnabled: {}, Excluded: {}, ShouldManage: {}", (Object)context, (Object)entityIdStr, (Object)hasConfig, (Object)isTamed, (Object)isGlobalEnabled, (Object)isExcluded, (Object)shouldManage);
        }
    }

    public static void scheduleAggroCancellation(LivingEntity entity, Entity target, int delayTicks) {
        if (entity == null || delayTicks <= 0) {
            return;
        }
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId == null) {
            return;
        }
        String entityIdStr = entityId.toString();
        if (!AggroManager.shouldManageEntity(entityIdStr)) {
            return;
        }
        UUID entityUUID = entity.m_20148_();
        if (scheduledAggroCancellations.containsKey(entityUUID)) {
            LOGGER.info("Aggro cancellation already scheduled for {}, not scheduling again", (Object)entityId);
            return;
        }
        scheduledAggroCancellations.put(entityUUID, new AggroData(entity, target, delayTicks));
        LOGGER.info("Scheduled aggro cancellation for {} targeting {} in {} ticks", (Object)entityId, target != null ? ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_()) : "null", (Object)delayTicks);
    }

    public static void cancelAggroImmediately(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId == null) {
            return;
        }
        String entityIdStr = entityId.toString();
        if (!AggroManager.shouldManageEntity(entityIdStr)) {
            return;
        }
        AggroManager.cancelEntityAggro(entity);
        scheduledAggroCancellations.remove(entity.m_20148_());
        LOGGER.info("Immediately cancelled aggro for {}", (Object)entityId);
    }

    private static boolean isTamedOrSummoned(LivingEntity entity) {
        if (entity instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)entity;
            return tamable.m_21824_();
        }
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)entity;
            return ownable.m_21805_() != null;
        }
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString();
        return entityId.contains("familiar") || entityId.contains("summon") || entityId.contains("minion") || entityId.contains("pet") || entityId.contains("mmorpg") || entityId.contains("mineslash") || entityId.contains("library_of_exile") || entity.m_19880_().contains("summoned") || entity.getPersistentData().m_128441_("SummonedEntity") || entity.getPersistentData().m_128441_("OwnerUUID");
    }

    public static void removeScheduledCancellation(LivingEntity entity) {
        if (entity != null) {
            scheduledAggroCancellations.remove(entity.m_20148_());
        }
    }

    public static boolean isInPeacefulMode(LivingEntity entity) {
        return entity != null && peacefulModeSchedule.containsKey(entity.m_20148_());
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        Map.Entry<UUID, Object> entry;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!scheduledAggroCancellations.isEmpty()) {
            Iterator<Map.Entry<UUID, AggroData>> iterator = scheduledAggroCancellations.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                AggroData aggroData = entry.getValue();
                if (aggroData.getEntity() == null || !aggroData.getEntity().m_6084_()) {
                    iterator.remove();
                    continue;
                }
                ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)aggroData.getEntity().m_6095_());
                if (entityId == null) {
                    iterator.remove();
                    continue;
                }
                String entityIdStr = entityId.toString();
                if (!AggroManager.shouldManageEntity(entityIdStr)) {
                    iterator.remove();
                    continue;
                }
                int newTicksRemaining = aggroData.getTicksRemaining() - 1;
                if (newTicksRemaining <= 0) {
                    LOGGER.info("Cancelling aggro for {} after {} ticks", (Object)entityId, (Object)aggroData.getTicksRemaining());
                    AggroManager.cancelEntityAggro(aggroData.getEntity());
                    iterator.remove();
                    LOGGER.info("Successfully cancelled aggro for {} after timer expired", (Object)entityId);
                    continue;
                }
                entry.setValue(new AggroData(aggroData.getEntity(), aggroData.getTarget(), newTicksRemaining));
                if (newTicksRemaining % 20 != 0) continue;
                LOGGER.info("Aggro cancellation for {} in {} ticks ({} seconds)", (Object)entityId, (Object)newTicksRemaining, (Object)(newTicksRemaining / 20));
            }
        }
        if (!peacefulModeSchedule.isEmpty()) {
            Iterator<Map.Entry<UUID, Integer>> peacefulIterator = peacefulModeSchedule.entrySet().iterator();
            while (peacefulIterator.hasNext()) {
                entry = peacefulIterator.next();
                UUID entityUUID = entry.getKey();
                int ticksRemaining = (Integer)entry.getValue() - 1;
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server != null) {
                    block2: for (ServerLevel level : server.m_129785_()) {
                        for (Entity entity : level.m_8583_()) {
                            if (!entity.m_20148_().equals(entityUUID) || !(entity instanceof Mob)) continue;
                            Mob mob = (Mob)entity;
                            if (!(mob.m_5448_() instanceof Player)) continue block2;
                            mob.m_6710_(null);
                            mob.m_21573_().m_26573_();
                            LOGGER.debug("Cleared target for peaceful entity: {}", (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()));
                            continue block2;
                        }
                    }
                }
                if (ticksRemaining <= 0) {
                    peacefulIterator.remove();
                    LOGGER.info("Peaceful mode expired for entity with UUID: {}", (Object)entityUUID);
                    continue;
                }
                entry.setValue(ticksRemaining);
            }
        }
    }

    public static void cancelEntityAggro(LivingEntity entity) {
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId == null) {
            return;
        }
        String entityIdStr = entityId.toString();
        try {
            mob.m_6710_(null);
            if (entity.getPersistentData().m_128441_("Anger")) {
                int oldAnger = entity.getPersistentData().m_128451_("Anger");
                entity.getPersistentData().m_128405_("Anger", 0);
                LOGGER.info("Reset MCA Anger for {} from {} to 0", (Object)entityIdStr, (Object)oldAnger);
            }
            if (entity.getPersistentData().m_128441_("Aggression")) {
                int oldAggression = entity.getPersistentData().m_128451_("Aggression");
                entity.getPersistentData().m_128405_("Aggression", 0);
                LOGGER.info("Reset MCA Aggression for {} from {} to 0", (Object)entityIdStr, (Object)oldAggression);
            }
            if (entity.getPersistentData().m_128441_("TargetPlayer")) {
                entity.getPersistentData().m_128473_("TargetPlayer");
                LOGGER.info("Removed TargetPlayer data for {}", (Object)entityIdStr);
            }
            try {
                int clearedGoals = 0;
                for (WrappedGoal prioritizedGoal : mob.f_21346_.m_148105_()) {
                    Goal goal = prioritizedGoal.m_26015_();
                    if (!(goal instanceof TargetGoal)) continue;
                    goal.m_8041_();
                    ++clearedGoals;
                    try {
                        Field[] fields;
                        for (Field field : fields = goal.getClass().getDeclaredFields()) {
                            if (field.getType() != LivingEntity.class) continue;
                            field.setAccessible(true);
                            field.set(goal, null);
                        }
                    }
                    catch (Exception exception) {
                    }
                }
                LOGGER.info("Cleared {} targeting goals for {}", (Object)clearedGoals, (Object)entityIdStr);
            }
            catch (Exception e) {
                LOGGER.warn("Could not clear targeting goals for {}: {}", (Object)entityIdStr, (Object)e.getMessage());
            }
            mob.f_21345_.m_25373_();
            mob.f_21346_.m_25373_();
            mob.m_21573_().m_26573_();
            AggroManager.schedulePeacefulMode(mob, 200);
            LOGGER.info("Successfully cancelled all aggro for {} and enabled peaceful mode", (Object)entityIdStr);
        }
        catch (Exception e) {
            ResourceLocation entityIdLoc = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
            LOGGER.error("Failed to cancel aggro for entity: {}", (Object)entityIdLoc, (Object)e);
        }
    }

    private static void schedulePeacefulMode(Mob mob, int delayTicks) {
        UUID entityUUID = mob.m_20148_();
        peacefulModeSchedule.put(entityUUID, delayTicks);
        LOGGER.info("Entity {} will be in peaceful mode for {} ticks", (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_()), (Object)delayTicks);
    }

    public static boolean hasScheduledCancellation(LivingEntity entity) {
        return entity != null && scheduledAggroCancellations.containsKey(entity.m_20148_());
    }

    public static int getRemainingTicks(LivingEntity entity) {
        if (entity == null) {
            return -1;
        }
        AggroData data = scheduledAggroCancellations.get(entity.m_20148_());
        return data != null ? data.getTicksRemaining() : -1;
    }

    public static void clearAllScheduled() {
        scheduledAggroCancellations.clear();
        peacefulModeSchedule.clear();
        LOGGER.info("Cleared all scheduled aggro cancellations and peaceful mode schedules");
    }

    public static boolean shouldManageEntity(String entityId) {
        if (ConfigurationManager.hasConfig(entityId)) {
            return true;
        }
        if (ConfigurationManager.getGlobalNeutralConfig().isEnabled()) {
            return !ConfigurationManager.getGlobalNeutralConfig().getExcludeEntitys().contains(entityId);
        }
        return false;
    }

    public static int getCancelAggroTimeForEntity(String entityId) {
        return ConfigurationManager.getCancelAggroTime(entityId);
    }

    public static boolean shouldBeNeutralUntilAttacked(String entityId) {
        return ConfigurationManager.shouldBeNeutralUntilAttacked(entityId);
    }

    public static boolean canEntityDamagePlayer(String entityId) {
        return ConfigurationManager.canDamagePlayer(entityId);
    }

    private static class AggroData {
        private final LivingEntity entity;
        private final Entity target;
        private final int ticksRemaining;

        public AggroData(LivingEntity entity, Entity target, int ticksRemaining) {
            this.entity = entity;
            this.target = target;
            this.ticksRemaining = ticksRemaining;
        }

        public LivingEntity getEntity() {
            return this.entity;
        }

        public Entity getTarget() {
            return this.target;
        }

        public int getTicksRemaining() {
            return this.ticksRemaining;
        }
    }
}

