/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.potion_effects;

import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffect;
import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffectInstanceData;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.SimpleStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.world.entity.LivingEntity;

public class EntityStatusEffectsData {
    public ConcurrentHashMap<String, ExileEffectInstanceData> exileMap = new ConcurrentHashMap();

    public int getStacks(String eff) {
        if (this.exileMap.containsKey(eff)) {
            return this.exileMap.get((Object)eff).stacks;
        }
        return 0;
    }

    public void tick(LivingEntity en) {
        if (this.exileMap.isEmpty()) {
            return;
        }
        this.exileMap.entrySet().removeIf(x -> !ExileDB.ExileEffects().isRegistered((String)x.getKey()));
        for (Map.Entry<String, ExileEffectInstanceData> e : this.exileMap.entrySet()) {
            --e.getValue().ticks_left;
            ExileEffect eff = (ExileEffect)ExileDB.ExileEffects().get(e.getKey());
            if (eff == null) continue;
            eff.onTick(en, e.getValue());
        }
        ArrayList removed = new ArrayList();
        if (en.f_19797_ % 80 == 0) {
            this.exileMap.entrySet().removeIf(x -> {
                if (((ExileEffectInstanceData)x.getValue()).shouldRemove() || ((ExileEffectInstanceData)x.getValue()).isSpellNoLongerAllocated(en)) {
                    removed.add((ExileEffect)ExileDB.ExileEffects().get((String)x.getKey()));
                    return true;
                }
                return false;
            });
        } else {
            this.exileMap.entrySet().removeIf(x -> {
                if (((ExileEffectInstanceData)x.getValue()).shouldRemove()) {
                    removed.add((ExileEffect)ExileDB.ExileEffects().get((String)x.getKey()));
                    return true;
                }
                return false;
            });
        }
        for (ExileEffect eff : removed) {
            eff.onRemove(en);
        }
    }

    public boolean has(ExileEffect eff) {
        return this.exileMap.containsKey(eff.GUID()) && !this.exileMap.get(eff.GUID()).shouldRemove();
    }

    public ExileEffectInstanceData get(ExileEffect eff) {
        return this.exileMap.getOrDefault(eff.GUID(), new ExileEffectInstanceData());
    }

    public ExileEffectInstanceData getOrCreate(ExileEffect eff) {
        if (!this.exileMap.containsKey(eff.GUID())) {
            this.exileMap.put(eff.GUID(), new ExileEffectInstanceData());
        }
        return this.exileMap.getOrDefault(eff.GUID(), new ExileEffectInstanceData());
    }

    public void delete(ExileEffect eff) {
        this.exileMap.remove(eff.GUID());
    }

    public List<ExileEffect> getEffects() {
        return this.exileMap.keySet().stream().map(x -> (ExileEffect)ExileDB.ExileEffects().get(x)).collect(Collectors.toList());
    }

    public StatContext getStats(LivingEntity en) {
        ArrayList<ExactStatData> stats = new ArrayList<ExactStatData>();
        for (Map.Entry<String, ExileEffectInstanceData> e : this.exileMap.entrySet()) {
            ExileEffect eff = (ExileEffect)ExileDB.ExileEffects().get(e.getKey());
            if (eff == null) continue;
            ExileEffectInstanceData data = e.getValue();
            stats.addAll(eff.getExactStats(e.getValue().getCaster(en.m_9236_()), data.getSpell(), data.stacks, data.str_multi));
        }
        return new SimpleStatCtx(StatContext.StatCtxType.POTION_EFFECT, stats);
    }
}

