/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.packets.spells;

import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.main.Packets;
import com.robertx22.library_of_exile.packets.ExilePacketContext;
import com.robertx22.mine_and_slash.a_libraries.player_animations.PlayerAnimations;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class TellClientEntityCastingSpell
extends MyPacket<TellClientEntityCastingSpell> {
    public String spellid = "";
    public int enid = 0;
    public PlayerAnimations.CastEnum type;

    public static void sendUpdates(PlayerAnimations.CastEnum e, Player p, Spell spell) {
        TellClientEntityCastingSpell packet = new TellClientEntityCastingSpell(e, (LivingEntity)p, spell);
        Packets.sendToTracking((MyPacket)packet, (Entity)p);
        Packets.sendToClient((Player)p, (MyPacket)packet);
    }

    private TellClientEntityCastingSpell(PlayerAnimations.CastEnum e, LivingEntity en, Spell spell) {
        this.spellid = spell.GUID();
        this.enid = en.m_19879_();
        this.type = e;
    }

    public TellClientEntityCastingSpell() {
    }

    public ResourceLocation getIdentifier() {
        return new ResourceLocation("mmorpg", "tellclienttocastspell");
    }

    public void loadFromData(FriendlyByteBuf tag) {
        this.spellid = tag.m_130277_();
        this.type = (PlayerAnimations.CastEnum)tag.m_130066_(PlayerAnimations.CastEnum.class);
        this.enid = tag.readInt();
    }

    public void saveToData(FriendlyByteBuf tag) {
        tag.m_130070_(this.spellid);
        tag.m_130068_((Enum)this.type);
        tag.writeInt(this.enid);
    }

    public void onReceived(ExilePacketContext ctx) {
        LivingEntity en = (LivingEntity)ctx.getPlayer().m_9236_().m_6815_(this.enid);
        if (en instanceof Player) {
            Player p = (Player)en;
            Spell spell = (Spell)ExileDB.Spells().get(this.spellid);
            PlayerAnimations.onSpellCast(p, spell, this.type);
        }
    }

    public MyPacket<TellClientEntityCastingSpell> newInstance() {
        return new TellClientEntityCastingSpell();
    }
}

