/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.packets.interaction;

import com.google.common.collect.ImmutableMap;
import com.robertx22.mine_and_slash.a_libraries.dmg_number_particle.particle.InteractionResultHandler;
import com.robertx22.mine_and_slash.config.forge.ClientConfigs;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEvent;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;

public interface IParticleSpawnMaterial {
    public void saveToBuf(FriendlyByteBuf var1);

    public IParticleSpawnMaterial loadFromData(FriendlyByteBuf var1);

    public InteractionResultHandler.ExileParticleType getSpawnType();

    public void spawnOnClient(Entity var1);

    public record HealNumber(float number) implements IParticleSpawnMaterial
    {
        @Override
        public void saveToBuf(FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.writeFloat(this.number);
        }

        @Override
        public IParticleSpawnMaterial loadFromData(FriendlyByteBuf friendlyByteBuf) {
            return new HealNumber(friendlyByteBuf.readFloat());
        }

        @Override
        public InteractionResultHandler.ExileParticleType getSpawnType() {
            return InteractionResultHandler.ExileParticleType.HEAL;
        }

        @Override
        public void spawnOnClient(Entity entity) {
            ((InteractionResultHandler.ClientSpawnStrategy)((Object)ClientConfigs.getConfig().DAMAGE_PARTICLE_STYLE.get())).healStrategy.accept(this, entity);
        }
    }

    public record DamageInformation(byte[] elements, FloatList damage, boolean isCrit) implements IParticleSpawnMaterial
    {
        public static DamageInformation fromDmgByElement(DamageEvent.DmgByElement mat, boolean isCrit) {
            HashMap<Elements, Float> dmgmap = mat.getDmgmap();
            int size = dmgmap.size();
            byte[] bytes = new byte[size];
            AtomicInteger i = new AtomicInteger(0);
            FloatArrayList floats = new FloatArrayList();
            dmgmap.forEach((key, value1) -> {
                float value = value1.floatValue();
                bytes[i.getAndIncrement()] = (byte)key.ordinal();
                floats.add(value);
            });
            return new DamageInformation(bytes, (FloatList)floats, isCrit);
        }

        public ImmutableMap<Elements, Float> getDmgMap() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < this.elements.length; ++i) {
                builder.put((Object)Elements.values()[this.elements[i]], (Object)Float.valueOf(this.damage.getFloat(i)));
            }
            return builder.build();
        }

        @Override
        public void saveToBuf(FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.m_130087_(this.elements);
            friendlyByteBuf.m_236828_((Collection)this.damage, FriendlyByteBuf::writeFloat);
            friendlyByteBuf.writeBoolean(this.isCrit);
        }

        @Override
        public DamageInformation loadFromData(FriendlyByteBuf friendlyByteBuf) {
            byte[] bytes = friendlyByteBuf.m_130052_();
            return new DamageInformation(bytes, (FloatList)friendlyByteBuf.m_236838_(FloatArrayList::new, FriendlyByteBuf::readFloat), friendlyByteBuf.readBoolean());
        }

        @Override
        public InteractionResultHandler.ExileParticleType getSpawnType() {
            return InteractionResultHandler.ExileParticleType.DAMAGE;
        }

        @Override
        public void spawnOnClient(Entity entity) {
            ((InteractionResultHandler.ClientSpawnStrategy)((Object)ClientConfigs.getConfig().DAMAGE_PARTICLE_STYLE.get())).damageStrategy.accept(this, entity);
        }
    }

    public static enum Type implements IParticleSpawnMaterial
    {
        DODGE(Words.DODGE.locName(), SoundEvents.f_12346_),
        RESIST(Words.RESIST.locName(), SoundEvents.f_12346_);

        public final MutableComponent text;
        public final SoundEvent sound;

        private Type(MutableComponent text, SoundEvent sound) {
            this.text = text;
            this.sound = sound;
        }

        @Override
        public void saveToBuf(FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.m_130068_((Enum)this);
        }

        @Override
        public IParticleSpawnMaterial loadFromData(FriendlyByteBuf friendlyByteBuf) {
            return (IParticleSpawnMaterial)((Object)friendlyByteBuf.m_130066_(Type.class));
        }

        @Override
        public InteractionResultHandler.ExileParticleType getSpawnType() {
            return InteractionResultHandler.ExileParticleType.NULLIFIED_DAMAGE;
        }

        @Override
        public void spawnOnClient(Entity entity) {
            ((InteractionResultHandler.ClientSpawnStrategy)((Object)ClientConfigs.getConfig().DAMAGE_PARTICLE_STYLE.get())).nullifiedDamageStrategy.accept(this, entity);
        }
    }
}

