/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.packets.backpack;

import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.packets.ExilePacketContext;
import com.robertx22.mine_and_slash.a_libraries.curios.CuriosSlots;
import com.robertx22.mine_and_slash.a_libraries.curios.MyCuriosUtils;
import com.robertx22.mine_and_slash.capability.player.BackpackItem;
import com.robertx22.mine_and_slash.capability.player.data.Backpacks;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class OpenBackpackPacket
extends MyPacket<OpenBackpackPacket> {
    public Backpacks.BackpackType type;

    public OpenBackpackPacket(Backpacks.BackpackType type) {
        this.type = type;
    }

    public ResourceLocation getIdentifier() {
        return SlashRef.id("open_backpack");
    }

    public void loadFromData(FriendlyByteBuf buf) {
        this.type = (Backpacks.BackpackType)buf.m_130066_(Backpacks.BackpackType.class);
    }

    public void saveToData(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.type);
    }

    public void onReceived(ExilePacketContext ctx) {
        Player player = ctx.getPlayer();
        Load.backpacks(player).getBackpacks().openBackpack(this.type, player);
    }

    @Nullable
    private static BackpackItem getBackpackItem(Player player) {
        Item item;
        Item item2 = player.m_21205_().m_41720_();
        if (item2 instanceof BackpackItem) {
            BackpackItem mainHand = (BackpackItem)item2;
            return mainHand;
        }
        ItemStack curioBackpack = MyCuriosUtils.get(CuriosSlots.MASTER_BAG.name, player, 0);
        if (!curioBackpack.m_41619_() && (item = curioBackpack.m_41720_()) instanceof BackpackItem) {
            BackpackItem curioBackpackItem = (BackpackItem)item;
            return curioBackpackItem;
        }
        return null;
    }

    public MyPacket<OpenBackpackPacket> newInstance() {
        return new OpenBackpackPacket(Backpacks.BackpackType.GEARS);
    }
}

