/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.packets.backpack;

import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.packets.ExilePacketContext;
import com.robertx22.mine_and_slash.capability.player.data.Backpacks;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class BackPackLootMenuPacket
extends MyPacket<BackPackLootMenuPacket> {
    Mode mode;

    public BackPackLootMenuPacket() {
    }

    public BackPackLootMenuPacket(Mode mode) {
        this.mode = mode;
    }

    public ResourceLocation getIdentifier() {
        return SlashRef.id("backpack_loot");
    }

    public void loadFromData(FriendlyByteBuf friendlyByteBuf) {
        this.mode = (Mode)friendlyByteBuf.m_130066_(Mode.class);
    }

    public void saveToData(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.m_130068_((Enum)this.mode);
    }

    public void onReceived(ExilePacketContext exilePacketContext) {
        Player player = exilePacketContext.getPlayer();
        if (player instanceof ServerPlayer) {
            Object object;
            ServerPlayer player2 = (ServerPlayer)player;
            Backpacks backpacks = Load.backpacks((Player)player2).getBackpacks();
            if (player2.m_242612_() && (object = player2.f_36096_) instanceof ChestMenu) {
                ChestMenu chestMenu = (ChestMenu)object;
                for (Slot slot : chestMenu.f_38839_) {
                    ItemStack item;
                    if (slot.f_40218_ instanceof Inventory || (item = slot.m_7993_()).m_150930_(Items.f_41852_)) continue;
                    if (this.mode == Mode.LOOT) {
                        if (Load.player((Player)player2).config.salvage.trySalvageOnPickup((Player)player2, item)) {
                            item.m_41774_(100);
                            continue;
                        }
                        backpacks.tryAutoPickup((Player)player2, item);
                        continue;
                    }
                    BackPackLootMenuPacket.turnItemToPickableAndRemove(item, (Player)player2);
                }
            }
        }
    }

    public static void turnItemToPickableAndRemove(ItemStack itemStacks, Player player) {
        ItemEntity itemEntity = player.m_5552_(itemStacks.m_41777_(), 1.0f);
        if (itemEntity != null) {
            itemEntity.m_32061_();
        }
        itemStacks.m_41774_(itemStacks.m_41613_());
    }

    public MyPacket<BackPackLootMenuPacket> newInstance() {
        return new BackPackLootMenuPacket();
    }

    public static enum Mode {
        LOOT,
        DROP;

    }
}

