/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.new_commands;

import com.mojang.brigadier.CommandDispatcher;
import com.robertx22.dungeon_realm.database.DungeonDatabase;
import com.robertx22.dungeon_realm.database.dungeon.Dungeon;
import com.robertx22.library_of_exile.command_wrapper.ArgumentWrapper;
import com.robertx22.library_of_exile.command_wrapper.CommandBuilder;
import com.robertx22.library_of_exile.command_wrapper.IntWrapper;
import com.robertx22.library_of_exile.command_wrapper.PermWrapper;
import com.robertx22.library_of_exile.command_wrapper.PlayerWrapper;
import com.robertx22.library_of_exile.command_wrapper.RegistryWrapper;
import com.robertx22.library_of_exile.dimension.structure.dungeon.DungeonRoom;
import com.robertx22.library_of_exile.dimension.structure.dungeon.RoomType;
import com.robertx22.mine_and_slash.vanilla_mc.commands.CommandRefs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;

public class BuilderToolCommands {
    public static void reg(CommandDispatcher dis) {
        CommandBuilder.of((String)CommandRefs.ID, (CommandDispatcher)dis, b -> {
            PlayerWrapper enarg = new PlayerWrapper();
            IntWrapper RADIUS = new IntWrapper("radius");
            IntWrapper HEIGHT = new IntWrapper("height");
            b.addLiteral("builder_tool_warning", PermWrapper.OP);
            b.addLiteral("generate_structure_blocks_per_chunk", PermWrapper.OP);
            b.addArg((ArgumentWrapper)RADIUS);
            b.addArg((ArgumentWrapper)HEIGHT);
            b.addArg((ArgumentWrapper)enarg);
            b.action(e -> {
                Player p = (Player)enarg.get(e);
                if (!p.m_7500_()) {
                    p.m_213846_((Component)Component.m_237113_((String)"You must be in creative mode to use this command. This is extra safety to make sure this command isn't usable accidentally."));
                    return;
                }
                ServerLevel world = (ServerLevel)p.m_9236_();
                BlockPos pos = p.m_20183_();
                int radius = (Integer)RADIUS.get(e);
                int height = (Integer)HEIGHT.get(e);
                ChunkPos cp = new ChunkPos(pos);
                for (int x = 0; x < radius; ++x) {
                    for (int z = 0; z < radius; ++z) {
                        ChunkPos cpos = new ChunkPos(cp.f_45578_ + x, cp.f_45579_ + z);
                        BlockPos fpos = cpos.m_151384_(0, pos.m_123342_(), 0);
                        StructureUtils.m_177764_((String)(x + "_" + z), (BlockPos)fpos, (Vec3i)new BlockPos(16, height, 16), (Rotation)Rotation.NONE, (ServerLevel)world);
                    }
                }
            });
        }, (String)"Gens structure blocks in radius for every chunk");
        CommandBuilder.of((String)CommandRefs.ID, (CommandDispatcher)dis, x -> {
            PlayerWrapper enarg = new PlayerWrapper();
            RegistryWrapper DUNGEON = new RegistryWrapper(DungeonDatabase.DUNGEON);
            x.addLiteral("builder_tool_warning", PermWrapper.OP);
            x.addLiteral("generate_dungeon_pieces", PermWrapper.OP);
            x.addArg((ArgumentWrapper)DUNGEON);
            x.addArg((ArgumentWrapper)enarg);
            x.action(e -> {
                Player p = (Player)enarg.get(e);
                if (!p.m_7500_()) {
                    p.m_213846_((Component)Component.m_237113_((String)"You must be in creative mode to use this command. This is extra safety to make sure this command isn't usable accidentally."));
                    return;
                }
                Level world = p.m_9236_();
                BlockPos pos = p.m_20183_();
                Dungeon dungeon = (Dungeon)DUNGEON.getFromRegistry(e);
                ChunkPos cp = new ChunkPos(pos);
                int i = 0;
                int z = 0;
                for (RoomType type : RoomType.values()) {
                    z = 0;
                    for (String room : dungeon.data.getRoomList(type)) {
                        DungeonRoom aroom = new DungeonRoom(dungeon.getDungeonData().folder, room, type);
                        BlockPos roomPos = new BlockPos(cp.m_45604_() + i * 20, pos.m_123342_(), cp.m_45609_() + z * 20);
                        world.m_7731_(roomPos, Blocks.f_50677_.m_49966_(), 2);
                        BlockEntity patt4467$temp = world.m_7702_(roomPos);
                        if (patt4467$temp instanceof StructureBlockEntity) {
                            StructureBlockEntity be = (StructureBlockEntity)patt4467$temp;
                            be.m_59874_(aroom.loc);
                            be.m_59885_(new BlockPos(0, 0, 0).m_7494_().m_122012_());
                            be.m_59842_((ServerLevel)world);
                        }
                        ++z;
                    }
                    ++i;
                }
                p.m_213846_((Component)Component.m_237113_((String)"Use the load_nearby_structures command if you want to load them too."));
            });
        }, (String)"Gens all dungeon pieces sorting them by type");
        CommandBuilder.of((String)CommandRefs.ID, (CommandDispatcher)dis, x -> {
            PlayerWrapper enarg = new PlayerWrapper();
            x.addLiteral("builder_tool_warning", PermWrapper.OP);
            x.addLiteral("load_nearby_structures", PermWrapper.OP);
            x.addArg((ArgumentWrapper)enarg);
            x.action(e -> {
                Player p = (Player)enarg.get(e);
                if (!p.m_7500_()) {
                    p.m_213846_((Component)Component.m_237113_((String)"You must be in creative mode to use this command. This is extra safety to make sure this command isn't usable accidentally."));
                    return;
                }
                Level world = p.m_9236_();
                ArrayList<ChunkPos> terrainChunks = new ArrayList<ChunkPos>();
                terrainChunks.add(new ChunkPos(p.m_20183_()));
                ChunkPos start = new ChunkPos(p.m_20183_());
                int terrain = 5;
                for (int i = -terrain; i < terrain; ++i) {
                    for (int z = -terrain; z < terrain; ++z) {
                        terrainChunks.add(new ChunkPos(start.f_45578_ + i, start.f_45579_ + z));
                    }
                }
                for (ChunkPos cp : terrainChunks) {
                    HashMap bes = new HashMap(world.m_6325_(cp.f_45578_, cp.f_45579_).m_62954_());
                    for (Map.Entry en : bes.entrySet()) {
                        Object patt6512$temp = en.getValue();
                        if (!(patt6512$temp instanceof StructureBlockEntity)) continue;
                        StructureBlockEntity be = (StructureBlockEntity)patt6512$temp;
                        be.m_59842_((ServerLevel)world);
                    }
                }
            });
        }, (String)"Loads all structure blocks");
    }
}

