/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.items.misc;

import com.robertx22.library_of_exile.tooltip.ExileTooltipUtils;
import com.robertx22.mine_and_slash.capability.player.PlayerData;
import com.robertx22.mine_and_slash.database.data.game_balance_config.PlayerPointsType;
import com.robertx22.mine_and_slash.uncommon.IShapedRecipe;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.vanilla_mc.items.misc.AutoItem;
import com.robertx22.mine_and_slash.vanilla_mc.items.misc.RarityStoneItem;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ResetPotion
extends AutoItem
implements IShapedRecipe {
    PlayerPointsType pointsType;
    ResetType reset;

    public ResetPotion(PlayerPointsType pointsType, ResetType reset) {
        super(new Item.Properties().m_41487_(64));
        this.pointsType = pointsType;
        this.reset = reset;
    }

    public String GUID() {
        return "";
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity player) {
        if (!world.f_46443_) {
            stack.m_41774_(1);
            if (player instanceof Player) {
                Player p = (Player)player;
                PlayerData data = Load.player(p);
                if (this.reset == ResetType.FULL_RESET) {
                    this.pointsType.fullReset(p);
                    Load.player((Player)p).spellCastingData.resetSpells();
                    data.getSkillGemInventory().removeSupportGemsIfTooMany(p);
                } else {
                    this.pointsType.addResetPoints(p, 10);
                }
                Load.player((Player)p).cachedStats.ALLOCATED.setDirtyAndSync(p);
                data.playerDataSync.setDirtyAndSync(p);
                Load.Unit((Entity)p).sync.setDirtyAndSync(p);
                p.m_36356_(new ItemStack((ItemLike)Items.f_42590_));
            }
        }
        return stack;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand handIn) {
        ItemStack itemStack = player.m_21120_(handIn);
        player.m_6672_(handIn);
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int m_8105_(ItemStack stack) {
        return 30;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> l, TooltipFlag pIsAdvanced) {
        if (this.reset == ResetType.ADD_POINTS) {
            l.addAll(ExileTooltipUtils.splitLongText((MutableComponent)Chats.RESET_POINTS_POTION_DESC.locName().m_130940_(ChatFormatting.AQUA)));
        } else {
            l.add((Component)Chats.RESET_FULL_POTION_DESC.locName().m_130940_(ChatFormatting.AQUA));
        }
    }

    @Override
    public ShapedRecipeBuilder getRecipe() {
        return this.shaped((ItemLike)this).m_126127_(Character.valueOf('v'), (ItemLike)this.reset.mat.get()).m_126127_(Character.valueOf('t'), (ItemLike)this.pointsType.matItem()).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42590_).m_126130_("vvv").m_126130_("vtv").m_126130_("vbv").m_126132_("player_level", this.trigger());
    }

    @Override
    public String locNameForLangFile() {
        return this.reset.name + " " + this.pointsType.word().locNameForLangFile() + " Potion";
    }

    public static enum ResetType {
        ADD_POINTS(() -> RarityStoneItem.of("common"), "Minor Reset", "reset_points"),
        FULL_RESET(() -> RarityStoneItem.of("mythic"), "Major Reset", "full_reset");

        public Supplier<Item> mat;
        public String name;
        public String id;

        private ResetType(Supplier<Item> mat, String name, String id) {
            this.mat = mat;
            this.name = name;
            this.id = id;
        }
    }
}

