/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.items.misc;

import com.robertx22.mine_and_slash.aoe_data.database.gear_slots.GearSlots;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.BaseGearType;
import com.robertx22.mine_and_slash.database.data.perks.Perk;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.talent_tree.TalentTree;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.itemstack.CustomItemData;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.ExileStacklessData;
import com.robertx22.mine_and_slash.itemstack.StackKeys;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.GearBlueprint;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class ItemNewbieGearBag
extends Item {
    static HashMap<String, NewbieContent> MAP = new HashMap();
    static NewbieContent defaultContent = new NewbieContent(Arrays.asList(GearSlots.STAFF, GearSlots.SWORD, GearSlots.BOW));

    public ItemNewbieGearBag() {
        super(new Item.Properties());
    }

    static void giveNewbieItemsFor(Player player, Perk perk) {
        NewbieContent c = defaultContent;
        if (MAP.containsKey(perk.GUID())) {
            c = MAP.get(perk.GUID());
        }
        c.give(player);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!worldIn.f_46443_) {
            try {
                List starts = Load.player((Player)playerIn).talents.getAllAllocatedPerks(TalentTree.SchoolType.TALENTS).values().stream().filter(x -> x.is_entry).collect(Collectors.toList());
                defaultContent.give(playerIn);
                playerIn.m_21120_(handIn).m_41774_(1);
                return new InteractionResultHolder(InteractionResult.PASS, (Object)playerIn.m_21120_(handIn));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)playerIn.m_21120_(handIn));
    }

    static class NewbieContent {
        public List<String> gearslots;
        public List<ItemStack> stacks = new ArrayList<ItemStack>();

        public NewbieContent(List<String> gearslots) {
            this.gearslots = gearslots;
        }

        public NewbieContent addStack(ItemStack stack) {
            this.stacks.add(stack);
            return this;
        }

        public void give(Player player) {
            this.gearslots.forEach(x -> {
                BaseGearType gear = (BaseGearType)ExileDB.GearTypes().getFilterWrapped(e -> e.gear_slot.equals(x)).random();
                GearBlueprint b = new GearBlueprint(LootInfo.ofLevel(1));
                b.level.set(1);
                b.rarity.set((GearRarity)ExileDB.GearRarities().get("common"));
                b.gearItemSlot.set(gear);
                ExileStacklessData ex = b.createData();
                GearItemData data = ex.get(StackKeys.GEAR);
                ex.getOrCreate(StackKeys.CUSTOM).data.set(CustomItemData.KEYS.SALVAGING_DISABLED, true);
                ItemStack stack = data.GetBaseGearType().getRandomItem(data.getRarity()).m_7968_();
                data.saveToStack(stack);
                ExileStack exfi = ExileStack.of(stack);
                ex.apply(exfi);
                stack = exfi.getStack();
                EnchantedBookItem.m_41153_((ItemStack)stack, (EnchantmentInstance)new EnchantmentInstance(Enchantments.f_44986_, 3));
                PlayerUtils.giveItem(stack, player);
            });
            this.stacks.forEach(x -> PlayerUtils.giveItem(x, player));
        }
    }
}

