/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.items;

import com.robertx22.library_of_exile.deferred.RegObj;
import com.robertx22.library_of_exile.utils.SoundUtils;
import com.robertx22.mine_and_slash.database.data.profession.ICreativeTabTiered;
import com.robertx22.mine_and_slash.database.data.profession.LeveledItem;
import com.robertx22.mine_and_slash.database.data.profession.all.Professions;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.texts.ExileTooltips;
import com.robertx22.mine_and_slash.gui.texts.textblocks.LeveledItemBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.NameBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.RarityBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.dropblocks.ProfessionDropSourceBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.usableitemblocks.UsageBlock;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.RarityItems;
import com.robertx22.mine_and_slash.saveclasses.unit.ResourceType;
import com.robertx22.mine_and_slash.saveclasses.unit.ResourcesData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EventBuilder;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.RestoreType;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.HealthUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.StringUTIL;
import com.robertx22.mine_and_slash.vanilla_mc.items.misc.AutoItem;
import com.robertx22.temp.SkillItemTier;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SlashPotionItem
extends AutoItem
implements ICreativeTabTiered {
    String rar;
    Type type;

    public SlashPotionItem(String rar, Type type) {
        super(new Item.Properties().m_41487_(64));
        this.rar = rar;
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String locNameForLangFile() {
        return StringUTIL.capitalise(this.rar) + " " + this.type.name + " Potion";
    }

    public String GUID() {
        return null;
    }

    @Override
    public Item getThis() {
        return this;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        int num = (int)this.type.getHealPercent(pStack);
        pTooltipComponents.clear();
        pTooltipComponents.addAll(new ExileTooltips().accept(new NameBlock(pStack.m_41786_())).accept(new RarityBlock(this.getRarity())).accept(new ProfessionDropSourceBlock(Professions.ALCHEMY)).accept(new UsageBlock(Collections.singletonList(Itemtips.Restores.locName(Component.m_237113_((String)(num + "%")).m_130940_(ChatFormatting.GREEN), this.type.name).m_130940_(ChatFormatting.GRAY)))).accept(new LeveledItemBlock(pStack)).accept(new UsageBlock(Collections.singletonList(Words.COOLDOWN.locName(Component.m_237113_((String)("" + this.getCooldownTicks() / 20)).m_130940_(ChatFormatting.GOLD)).m_130940_(ChatFormatting.GOLD)))).release());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player p, InteractionHand pUsedHand) {
        ItemStack stack = p.m_21120_(pUsedHand);
        if (!pLevel.f_46443_) {
            this.handlePotionRestore(p, stack);
        }
        return InteractionResultHolder.m_19098_((Object)p.m_21120_(pUsedHand));
    }

    public boolean handlePotionRestore(Player p, ItemStack stack) {
        boolean b = this.type.restoreResource(p, stack, this);
        if (b) {
            this.type.getSameTypePotions().forEach(x -> p.m_36335_().m_41524_((Item)x, this.getCooldownTicks()));
            SoundUtils.playSound((Entity)p, (SoundEvent)SoundEvents.f_11911_);
            stack.m_41774_(1);
        }
        return b;
    }

    public int getCooldownTicks() {
        return 600;
    }

    public GearRarity getRarity() {
        return (GearRarity)ExileDB.GearRarities().get(this.rar);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Type {
        HP("Health", Items.f_42620_){

            @Override
            public boolean restoreResource(Player player, ItemStack itemStack, SlashPotionItem slashPotionItem) {
                float healPercent = this.getHealPercent(itemStack);
                ResourcesData resources = Load.Unit((Entity)player).getResources();
                if ((float)HealthUtils.getCurrentHealth((LivingEntity)player) < HealthUtils.getMaxHealth((LivingEntity)player) || resources.getMagicShield() < resources.getMax((LivingEntity)player, ResourceType.magic_shield)) {
                    EventBuilder.ofRestore((LivingEntity)player, (LivingEntity)player, ResourceType.health, RestoreType.potion, HealthUtils.getMaxHealth((LivingEntity)player) * healPercent / 100.0f).build().Activate();
                    EventBuilder.ofRestore((LivingEntity)player, (LivingEntity)player, ResourceType.magic_shield, RestoreType.potion, Load.Unit((Entity)player).getUnit().magicShieldData().getValue() * healPercent / 100.0f).build().Activate();
                    return true;
                }
                return false;
            }

            @Override
            public List<SlashPotionItem> getSameTypePotions() {
                return RarityItems.HEALTH_POTIONS.values().stream().map(RegObj::get).collect(Collectors.toList());
            }

            @Override
            public float getHealPercent(ItemStack stack) {
                GearRarity r = ((SlashPotionItem)stack.m_41720_()).getRarity();
                SkillItemTier tier = LeveledItem.getTier(stack);
                return 5.0f + 0.25f * (float)r.stat_percents.max * tier.statMulti;
            }
        }
        ,
        MANA("Mana", Items.f_42619_){

            @Override
            public boolean restoreResource(Player player, ItemStack itemStack, SlashPotionItem slashPotionItem) {
                float healPercent = this.getHealPercent(itemStack);
                ResourcesData resources = Load.Unit((Entity)player).getResources();
                if (resources.getMana() < resources.getMax((LivingEntity)player, ResourceType.mana) || resources.getEnergy() < resources.getMax((LivingEntity)player, ResourceType.energy)) {
                    EventBuilder.ofRestore((LivingEntity)player, (LivingEntity)player, ResourceType.mana, RestoreType.potion, Load.Unit((Entity)player).getUnit().manaData().getValue() * healPercent / 100.0f).build().Activate();
                    EventBuilder.ofRestore((LivingEntity)player, (LivingEntity)player, ResourceType.energy, RestoreType.potion, Load.Unit((Entity)player).getUnit().energyData().getValue() * healPercent / 100.0f).build().Activate();
                    return true;
                }
                return false;
            }

            @Override
            public List<SlashPotionItem> getSameTypePotions() {
                return RarityItems.RESOURCE_POTIONS.values().stream().map(RegObj::get).collect(Collectors.toList());
            }

            @Override
            public float getHealPercent(ItemStack stack) {
                GearRarity r = ((SlashPotionItem)stack.m_41720_()).getRarity();
                SkillItemTier tier = LeveledItem.getTier(stack);
                return 5.0f + 0.25f * (float)r.stat_percents.max * tier.statMulti;
            }
        };

        String name;
        Item craftItem;

        public abstract boolean restoreResource(Player var1, ItemStack var2, SlashPotionItem var3);

        public abstract List<SlashPotionItem> getSameTypePotions();

        public abstract float getHealPercent(ItemStack var1);

        private Type(String name, Item craftItem) {
            this.name = name;
            this.craftItem = craftItem;
        }
    }
}

