/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.commands.report;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.robertx22.dungeon_realm.main.DungeonMain;
import com.robertx22.dungeon_realm.structure.DungeonMapData;
import com.robertx22.dungeon_realm.structure.DungeonMapStructure;
import com.robertx22.library_of_exile.dimension.structure.MapStructure;
import com.robertx22.library_of_exile.dimension.structure.dungeon.BuiltRoom;
import com.robertx22.library_of_exile.dimension.structure.dungeon.DungeonBuilder;
import com.robertx22.mine_and_slash.vanilla_mc.commands.CommandRefs;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class ReportMapIssue {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)CommandRefs.ID).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"report").requires(e -> e.m_6761_(0))).then(Commands.m_82127_((String)"map_bug").executes(ctx -> ReportMapIssue.run((CommandSourceStack)ctx.getSource())))));
    }

    private static int run(CommandSourceStack source) {
        try {
            Entity entity = source.m_81373_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)entity;
                Object text = "Map Bug Report, Problem Room: ";
                Optional dungeonMapData = DungeonMain.ifMapData((Level)p.m_9236_(), (BlockPos)p.m_20097_());
                if (dungeonMapData.isEmpty()) {
                    p.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.RED + "You must be standing in a dungeon to use this command.")));
                    return 1;
                }
                DungeonBuilder builder = new DungeonBuilder(DungeonMapStructure.dungeonSettings((ChunkPos)p.m_146902_(), (String)((DungeonMapData)dungeonMapData.get()).dungeon));
                builder.build();
                BuiltRoom room = builder.builtDungeon.getRoomForChunk((MapStructure)DungeonMain.MAIN_DUNGEON_STRUCTURE, p.m_146902_());
                text = (String)text + room.room.loc.toString();
                p.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.GREEN + "-----------------------")));
                p.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.AQUA + "Please make sure the problem is in the same chunk, or stand in the same spot as the map problem when using the command.")));
                p.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.RED + (String)text)));
                p.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.YELLOW + ChatFormatting.BOLD + "Click Here to Copy Text. Then Paste the text in a bug report.")).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, (String)text))));
                p.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.GREEN + "-----------------------")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }
}

