/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.commands.giveitems;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.MapBlueprint;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import com.robertx22.mine_and_slash.vanilla_mc.commands.CommandRefs;
import com.robertx22.mine_and_slash.vanilla_mc.commands.suggestions.GearRaritySuggestions;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class GiveMap {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)CommandRefs.ID).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"give").requires(e -> e.m_6761_(2))).then(Commands.m_82127_((String)"map").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"rarity", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new GearRaritySuggestions()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5000)).executes(e -> GiveMap.execute((CommandSourceStack)e.getSource(), (Player)EntityArgument.m_91474_((CommandContext)e, (String)"target"), IntegerArgumentType.getInteger((CommandContext)e, (String)"level"), StringArgumentType.getString((CommandContext)e, (String)"rarity"), IntegerArgumentType.getInteger((CommandContext)e, (String)"amount"))))))))));
    }

    private static int execute(CommandSourceStack commandSource, Player player, int lvl, String rarity, int amount) {
        if (Objects.isNull(player)) {
            try {
                player = commandSource.m_81375_();
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                return 1;
            }
        }
        for (int i = 0; i < amount; ++i) {
            MapBlueprint blueprint = new MapBlueprint(LootInfo.ofLevel(1));
            ItemStack mapStack = blueprint.createStack();
            MapBlueprint b = new MapBlueprint(LootInfo.ofLevel(lvl));
            b.level.set(lvl);
            if (ExileDB.GearRarities().isRegistered(rarity)) {
                b.rarity.set((GearRarity)ExileDB.GearRarities().get(rarity));
            }
            StackSaving.MAP.saveTo(mapStack, (Object)b.createData());
            PlayerUtils.giveItem(mapStack, player);
        }
        return 0;
    }
}

