/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.commands.giveitems;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.unique_items.UniqueGear;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.GearBlueprint;
import com.robertx22.mine_and_slash.vanilla_mc.commands.CommandRefs;
import com.robertx22.mine_and_slash.vanilla_mc.commands.suggestions.DatabaseSuggestions;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.world.entity.player.Player;

public class GiveExactUnique {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)CommandRefs.ID).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"give").requires(e -> e.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unique_gear").requires(e -> e.m_6761_(2))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"uniqueID", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new DatabaseSuggestions(ExileRegistryTypes.UNIQUE_GEAR, "random")).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5000)).executes(e -> GiveExactUnique.execute((CommandSourceStack)e.getSource(), (Player)EntityArgument.m_91474_((CommandContext)e, (String)"target"), StringArgumentType.getString((CommandContext)e, (String)"uniqueID"), IntegerArgumentType.getInteger((CommandContext)e, (String)"level"), IntegerArgumentType.getInteger((CommandContext)e, (String)"amount"))))))))));
    }

    private static int execute(CommandSourceStack commandSource, Player player, String id, int lvl, int amount) {
        if (Objects.isNull(player)) {
            try {
                player = commandSource.m_81375_();
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                return 1;
            }
        }
        for (int i = 0; i < amount; ++i) {
            GearBlueprint blueprint = new GearBlueprint(LootInfo.ofLevel(lvl));
            blueprint.level.set(lvl);
            if (!id.equals("random")) {
                blueprint.rarity.set((GearRarity)ExileDB.GearRarities().get(((UniqueGear)ExileDB.UniqueGears().random()).rarity));
                blueprint.uniquePart.set((UniqueGear)ExileDB.UniqueGears().get(id));
                blueprint.gearItemSlot.set(((UniqueGear)blueprint.uniquePart.get()).getBaseGear());
            } else {
                blueprint.rarity.set((GearRarity)ExileDB.GearRarities().getFilterWrapped(x -> x.is_unique_item).random());
                blueprint.uniquePart.set((UniqueGear)ExileDB.UniqueGears().getFilterWrapped(x -> x.rarity.equals(((GearRarity)blueprint.rarity.get()).GUID())).random());
                blueprint.gearItemSlot.set(((UniqueGear)blueprint.uniquePart.get()).getBaseGear());
            }
            player.m_36356_(blueprint.createStack());
        }
        return 0;
    }
}

