/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.commands.entity;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.MasterLootGen;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import com.robertx22.mine_and_slash.vanilla_mc.commands.CommandRefs;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class GiveLoot {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)CommandRefs.ID).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"give").requires(e -> e.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"loot").requires(e -> e.m_6761_(2))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"source", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"log_only", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"filter", (ArgumentType)StringArgumentType.string()).executes(ctx -> GiveLoot.run((Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"target"), EntityArgument.m_91452_((CommandContext)ctx, (String)"source"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"log_only") != 0, StringArgumentType.getString((CommandContext)ctx, (String)"filter")))))))))));
    }

    private static int run(Player player, Entity source, int count, boolean logOnly, String filter) {
        if (!(source instanceof LivingEntity)) {
            player.m_213846_((Component)Component.m_237113_((String)"Source must be a living entity"));
            return 0;
        }
        LivingEntity living = (LivingEntity)source;
        LootInfo lootInfo = LootInfo.ofMobKilled(player, living);
        lootInfo.gatherLootMultipliers();
        Predicate<ItemStack> predicate = s -> s.m_41720_().toString().contains(filter);
        try {
            if (logOnly) {
                GiveLoot.logItems(player, lootInfo, count, predicate);
            } else {
                GiveLoot.dropItems(player, lootInfo, count, predicate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    private static void dropItems(Player player, LootInfo lootInfo, int count, Predicate<ItemStack> filter) {
        for (int i = 0; i < count; ++i) {
            List<ItemStack> loot = MasterLootGen.generateLoot(lootInfo);
            for (ItemStack stack : loot) {
                if (!filter.test(stack)) continue;
                PlayerUtils.giveItem(stack, player);
            }
        }
    }

    private static void logItems(Player player, LootInfo lootInfo, int count, Predicate<ItemStack> filter) {
        HashMap<Item, Integer> itemCounts = new HashMap<Item, Integer>();
        for (int i = 0; i < count; ++i) {
            List<ItemStack> loot = MasterLootGen.generateLoot(lootInfo);
            for (ItemStack stack : loot) {
                if (!filter.test(stack)) continue;
                Item item = stack.m_41720_();
                itemCounts.put(item, itemCounts.getOrDefault(item, 0) + stack.m_41613_());
            }
        }
        LinkedList list = new LinkedList(itemCounts.entrySet());
        list.sort(Comparator.comparingInt(e -> (Integer)e.getValue()));
        player.m_213846_((Component)Component.m_237113_((String)"Loot:").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
        for (Map.Entry entry : list) {
            ResourceLocation itemResource = BuiltInRegistries.f_257033_.m_7981_((Object)((Item)entry.getKey()));
            String itemString = itemResource.m_135827_() + ":" + itemResource.m_135815_();
            player.m_213846_((Component)Component.m_237113_((String)(itemString + ": " + entry.getValue())));
        }
    }
}

