/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.library_of_exile.tooltip.ExileTooltipUtils;
import com.robertx22.library_of_exile.util.UNICODE;
import com.robertx22.library_of_exile.utils.CLOC;
import com.robertx22.library_of_exile.wrappers.ExileText;
import com.robertx22.mine_and_slash.config.forge.ClientConfigs;
import com.robertx22.mine_and_slash.database.data.gear_slots.GearSlot;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RepairUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TooltipUtils {
    public static String CHECKMARK = ChatFormatting.GREEN + "\u2714";
    public static String X = ChatFormatting.RED + "\u2716";
    static Character CHAR = Character.valueOf("\u00a7".charAt(0));

    public static MutableComponent color(ChatFormatting format, MutableComponent comp) {
        return Component.m_237113_((String)("" + format)).m_7220_((Component)comp);
    }

    public static void addEmpty(List<Component> tooltip) {
        tooltip.add((Component)CLOC.blank((String)""));
    }

    public static List<String> compsToStrings(List<Component> list) {
        return list.stream().map(x -> x.getString()).collect(Collectors.toList());
    }

    public static MutableComponent level(int lvl) {
        return Component.m_237113_((String)"").m_7220_((Component)Itemtips.LEVEL_TIP.locName(lvl).m_130940_(ChatFormatting.YELLOW));
    }

    public static List<Component> cutIfTooLong(MutableComponent comp) {
        List<String> stringList = TooltipUtils.cutIfTooLong(comp.getString());
        return stringList.stream().map(x -> ExileText.ofText((String)x).get()).collect(Collectors.toList());
    }

    public static List<MutableComponent> cutIfTooLong(MutableComponent comp, ChatFormatting format) {
        List<String> stringList = TooltipUtils.cutIfTooLong(comp.getString());
        return stringList.stream().map(x -> ExileText.ofText((String)x).format(format).get()).collect(Collectors.toList());
    }

    public static List<String> cutIfTooLong(String str) {
        return Arrays.asList(str);
    }

    public static MutableComponent itemBrokenText(ItemStack stack, ICommonDataItem data) {
        if (data != null && RepairUtils.isItemBroken(stack)) {
            MutableComponent comp = Component.m_237113_((String)(UNICODE.SKULL + " ")).m_7220_((Component)Words.Broken.locName().m_130940_(ChatFormatting.RED));
            return comp;
        }
        return null;
    }

    public static List<Component> removeDoubleBlankLines(List<Component> list) {
        return TooltipUtils.removeDoubleBlankLines(list, (Integer)ClientConfigs.getConfig().REMOVE_EMPTY_TOOLTIP_LINES_IF_MORE_THAN_X_LINES.get());
    }

    private static List<Component> removeDoubleBlankLines(List<Component> list, int minLinesCutAllBlanks) {
        boolean alwaysRemoveEmpty;
        List newt = ExileTooltipUtils.removeBlankLines(list, (ExileTooltipUtils.RemoveOption)ExileTooltipUtils.RemoveOption.ONLY_DOUBLE_BLANK_LINES);
        boolean bl = alwaysRemoveEmpty = newt.size() > minLinesCutAllBlanks;
        if (alwaysRemoveEmpty) {
            newt = ExileTooltipUtils.removeBlankLines((List)newt, (ExileTooltipUtils.RemoveOption)ExileTooltipUtils.RemoveOption.ALL_BLANK_LINES);
        }
        return newt;
    }

    public static MutableComponent rarity(Rarity rarity) {
        return Itemtips.RARITY_TIP.locName().m_130940_(ChatFormatting.WHITE).m_7220_((Component)rarity.locName().m_130940_(rarity.textFormatting()));
    }

    public static MutableComponent rarityShort(Rarity rarity) {
        return Component.m_237113_((String)("" + rarity.textFormatting())).m_7220_((Component)rarity.locName().m_130940_(rarity.textFormatting()));
    }

    public static MutableComponent tier(int tier) {
        return Itemtips.TIER_TIP.locName(tier);
    }

    @NotNull
    public static MutableComponent gearSlot(GearSlot slot) {
        return Itemtips.ITEM_TYPE.locName(slot.locName().m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.WHITE);
    }

    public static MutableComponent gearTier(int tier) {
        return Itemtips.ITEM_TIER_TIP.locName(Component.m_237113_((String)("" + tier)).m_130940_(ChatFormatting.GOLD)).m_130940_(ChatFormatting.GOLD);
    }
}

