/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LookUtils {
    public static Entity getEntityLookedAt(Entity e) {
        List<Entity> list = LookUtils.getEntityLookedAt(e, 32.0, true);
        return list.isEmpty() ? null : list.get(0);
    }

    public static List<LivingEntity> getLivingEntityLookedAt(Entity e, double distance, boolean onlyfirst) {
        return LookUtils.getEntityLookedAt(e, distance, onlyfirst).stream().filter(x -> x instanceof LivingEntity).map(x -> (LivingEntity)x).collect(Collectors.toList());
    }

    public static List<Entity> getEntityLookedAt(Entity e, double distance, boolean onlyfirst) {
        Entity foundEntity = null;
        HitResult pos = LookUtils.raycast(e, distance);
        ArrayList<Entity> list = new ArrayList<Entity>();
        Vec3 positionVector = e.m_20182_();
        if (e instanceof Player) {
            positionVector = positionVector.m_82520_(0.0, (double)e.m_20192_(), 0.0);
        }
        if (pos != null) {
            distance = pos.m_82450_().m_82554_(positionVector);
        }
        Vec3 lookVector = e.m_20154_();
        Vec3 reachVector = positionVector.m_82520_(lookVector.f_82479_ * distance, lookVector.f_82480_ * distance, lookVector.f_82481_ * distance);
        Entity lookedEntity = null;
        List entitiesInBoundingBox = e.m_20193_().m_45933_(e, e.m_20191_().m_82377_(lookVector.f_82479_ * distance, lookVector.f_82480_ * distance, lookVector.f_82481_ * distance).m_82363_((double)1.2f, (double)1.2f, (double)1.2f));
        double minDistance = distance;
        for (Entity entity : entitiesInBoundingBox) {
            if (entity.m_6087_()) {
                double distanceToEntity;
                float collisionBorderSize = entity.m_6143_();
                AABB hitbox = entity.m_20191_().m_82363_((double)collisionBorderSize, (double)collisionBorderSize, (double)collisionBorderSize);
                Optional interceptPosition = hitbox.m_82371_(positionVector, reachVector);
                Vec3 interceptVec = interceptPosition.orElse(null);
                if (hitbox.m_82390_(positionVector)) {
                    if (0.0 < minDistance || minDistance == 0.0) {
                        lookedEntity = entity;
                        minDistance = 0.0;
                    }
                } else if (interceptVec != null && ((distanceToEntity = positionVector.m_82554_(interceptVec)) < minDistance || minDistance == 0.0)) {
                    lookedEntity = entity;
                    minDistance = distanceToEntity;
                }
            }
            if (lookedEntity == null || !(minDistance < distance) && pos != null) continue;
            foundEntity = lookedEntity;
        }
        if (onlyfirst) {
            if (foundEntity != null) {
                list.add(foundEntity);
            }
        } else {
            list.addAll(entitiesInBoundingBox);
        }
        return list;
    }

    public static HitResult raycast(Entity e, double len) {
        Vec3 look;
        Vec3 vec = new Vec3(e.m_20185_(), e.m_20186_(), e.m_20189_());
        if (e instanceof Player) {
            vec = vec.m_82549_(new Vec3(0.0, (double)e.m_20192_(), 0.0));
        }
        if ((look = e.m_20154_()) == null) {
            return null;
        }
        return LookUtils.raycast(e.m_20193_(), vec, look, e, len);
    }

    public static HitResult raycast(Level world, Vec3 origin, Vec3 ray, Entity e, double len) {
        Vec3 end = origin.m_82549_(ray.m_82541_().m_82490_(len));
        BlockHitResult pos = world.m_45547_(new ClipContext(origin, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, e));
        return pos;
    }
}

