/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.config.forge.compat.CompatConfig;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class HealthUtils {
    static AttributeModifier getHeartsAttributeMod(float num) {
        return new AttributeModifier(UUID.fromString("3fb10485-f309-128f-afc6-a55b0d6cf4c1"), BuiltInRegistries.f_256951_.m_7981_((Object)Attributes.f_22276_).toString(), (double)num, AttributeModifier.Operation.ADDITION);
    }

    public static void addHearts(LivingEntity en) {
        if (CompatConfig.get().healthSystem().usesVanillaHearts()) {
            float curmax = en.m_21233_();
            EntityData data = Load.Unit((Entity)en);
            int cur = (int)data.getUnit().healthData().getValue();
            if (data.lastHealth != cur) {
                data.lastHealth = cur;
            }
            AttributeModifier mod = HealthUtils.getHeartsAttributeMod(cur);
            AttributeInstance at = en.m_21051_(Attributes.f_22276_);
            if (en.m_21204_().m_22154_(Attributes.f_22276_, mod.m_22209_())) {
                at.m_22120_(mod.m_22209_());
            }
            data.heartsWithoutMnsHealth = (int)en.m_21233_();
            at.m_22125_(mod);
            float aftermax = en.m_21233_();
            if (aftermax > curmax) {
                float toheal = aftermax - curmax;
                en.m_5634_(toheal);
            }
        } else {
            AttributeModifier mod = HealthUtils.getHeartsAttributeMod(0.0f);
            AttributeInstance at = en.m_21051_(Attributes.f_22276_);
            if (en.m_21204_().m_22154_(Attributes.f_22276_, mod.m_22209_())) {
                at.m_22120_(mod.m_22209_());
            }
        }
    }

    public static void heal(LivingEntity en, float heal) {
        en.m_5634_(heal);
    }

    public static float realToVanilla(LivingEntity en, float dmg) {
        if (CompatConfig.get().healthSystem().usesVanillaHearts()) {
            return dmg;
        }
        float multi = dmg / HealthUtils.getMaxHealth(en);
        float max = en.m_21233_();
        float total = multi * max;
        return total;
    }

    public static float getMaxHealth(LivingEntity en) {
        if (CompatConfig.get().healthSystem().usesVanillaHearts()) {
            return en.m_21233_();
        }
        EntityData data = Load.Unit((Entity)en);
        if (en.m_9236_().f_46443_) {
            return data.getSyncedMaxHealth();
        }
        try {
            return data.getUnit().healthData().getValue();
        }
        catch (Exception e) {
            return 1.0f;
        }
    }

    public static int getCurrentHealth(LivingEntity entity) {
        if (CompatConfig.get().healthSystem().usesVanillaHearts()) {
            return (int)entity.m_21223_();
        }
        float multi = entity.m_21223_() / entity.m_21233_();
        float max = HealthUtils.getMaxHealth(entity);
        return (int)(max * multi);
    }

    public static int getCurrentMagicShield(LivingEntity entity) {
        return (int)Load.Unit((Entity)entity).getResources().getMagicShield();
    }

    public static int getCurrentHealthPlusMagicShield(LivingEntity entity) {
        return (int)((float)HealthUtils.getCurrentHealth(entity) + Load.Unit((Entity)entity).getResources().getMagicShield());
    }

    public static int getMaxHealthPlusMagicShield(LivingEntity entity) {
        int num = (int)(HealthUtils.getMaxHealth(entity) + Load.Unit((Entity)entity).getUnit().magicShieldData().getValue());
        if (num <= 0) {
            return 1;
        }
        return num;
    }

    public static float getHealthBarPercent(LivingEntity entity) {
        return Math.min(1.0f, (float)HealthUtils.getCurrentHealthPlusMagicShield(entity) * 1.0f / (float)HealthUtils.getMaxHealthPlusMagicShield(entity));
    }
}

