/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;

public class EntityTypeUtils {
    public static EntityClassification getType(LivingEntity entity) {
        if (EntityTypeUtils.isMob((Entity)entity)) {
            return EntityClassification.MOB;
        }
        if (EntityTypeUtils.isAnimal((Entity)entity)) {
            return EntityClassification.ANIMAL;
        }
        if (EntityTypeUtils.isNPC((Entity)entity)) {
            return EntityClassification.NPC;
        }
        if (entity instanceof Player) {
            return EntityClassification.PLAYER;
        }
        if (entity instanceof AmbientCreature || entity.m_6095_().m_20674_() == MobCategory.AMBIENT || entity.m_6095_().m_20674_() == MobCategory.WATER_AMBIENT) {
            return EntityClassification.AMBIENT;
        }
        return EntityClassification.OTHER;
    }

    public static boolean isMob(Entity en) {
        if (en instanceof Enemy) {
            return true;
        }
        if (en instanceof NeutralMob) {
            return true;
        }
        return !en.m_6095_().m_20674_().m_21609_();
    }

    public static boolean isAnimal(Entity en) {
        return en instanceof Animal;
    }

    public static boolean isNPC(Entity en) {
        return en instanceof Npc;
    }

    public static enum EntityClassification {
        MOB("mob"),
        PLAYER("player"),
        ANIMAL("animal"),
        NPC("npc"),
        AMBIENT("ambient"),
        OTHER("other");

        public String id;

        private EntityClassification(String id) {
            this.id = id;
        }
    }
}

