/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.stat_calculation;

import com.robertx22.library_of_exile.utils.EntityUtils;
import com.robertx22.mine_and_slash.aoe_data.database.stats.OffenseStats;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.data.DimensionConfig;
import com.robertx22.mine_and_slash.database.data.EntityConfig;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.database.data.rarities.MobRarity;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.types.SummonStat;
import com.robertx22.mine_and_slash.database.data.stats.types.defense.Armor;
import com.robertx22.mine_and_slash.database.data.stats.types.defense.DodgeRating;
import com.robertx22.mine_and_slash.database.data.stats.types.generated.ElementalResist;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.health.Health;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.health.HealthRegen;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.saveclasses.unit.Unit;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.MiscStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.ModType;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;

public class MobStatUtils {
    public static List<StatContext> addSummonStats(TamableAnimal en) {
        ArrayList<ExactStatData> stats = new ArrayList<ExactStatData>();
        LivingEntity caster = en.m_269323_();
        if (caster instanceof Player) {
            Player player = (Player)caster;
            Spell spell = Load.Unit((Entity)en).summonedPetData.getSourceSpell();
            Unit data = Load.player(player).getSpellUnitStats(spell);
            for (Map.Entry<String, StatData> e : data.getStats().stats.entrySet()) {
                Stat stat = e.getValue().GetStat();
                if (!(stat instanceof SummonStat)) continue;
                SummonStat sstat = (SummonStat)stat;
                stats.add(sstat.giveToSummon(e.getValue()));
            }
        }
        return Arrays.asList(new MiscStatCtx(stats));
    }

    public static List<StatContext> addMapTierStats(LivingEntity en) {
        ArrayList<StatContext> list = new ArrayList<StatContext>();
        WorldUtils.ifMapData(en.m_9236_(), en.m_20183_()).ifPresent(x -> {
            if (x.map != null) {
                list.add(new MiscStatCtx(x.map.getTierStats()));
            }
        });
        return list;
    }

    public static List<StatContext> getAffixStats(LivingEntity en) {
        ArrayList<StatContext> list = new ArrayList<StatContext>();
        Load.Unit((Entity)en).getAffixData().getAffixes().forEach(x -> list.addAll(x.getStatAndContext(en)));
        return list;
    }

    public static List<StatContext> getWorldMultiplierStats(LivingEntity en) {
        float val = (-1.0f + ExileDB.getDimensionConfig((LevelAccessor)en.m_9236_()).mob_strength_multi) * 100.0f;
        ArrayList<StatContext> list = new ArrayList<StatContext>();
        if (val == 0.0f) {
            return list;
        }
        ArrayList<ExactStatData> stats = new ArrayList<ExactStatData>();
        stats.add(ExactStatData.noScaling(val, ModType.MORE, Health.getInstance().GUID()));
        stats.add(ExactStatData.noScaling(val, ModType.MORE, OffenseStats.TOTAL_DAMAGE.get().GUID()));
        list.add(new MiscStatCtx(stats));
        return list;
    }

    public static List<StatContext> getMobConfigStats(LivingEntity entity, EntityData unitdata) {
        ArrayList<StatContext> list = new ArrayList<StatContext>();
        ArrayList<ExactStatData> stats = new ArrayList<ExactStatData>();
        EntityConfig config = ExileDB.getEntityConfig(entity, unitdata);
        config.stats.stats.forEach(x -> stats.add(x.toExactStat(unitdata.getLevel())));
        DimensionConfig dimConfig = ExileDB.getDimensionConfig((LevelAccessor)entity.m_9236_());
        dimConfig.stats.stats.forEach(x -> stats.add(x.toExactStat(unitdata.getLevel())));
        float hp = (float)((-1.0 + config.hp_multi) * 100.0);
        float dmg = (float)((-1.0 + config.dmg_multi) * 100.0);
        float stat = (float)((-1.0 + config.stat_multi) * 100.0);
        float expo = 100.0f * (float)(-1.0 + GameBalanceConfig.get().MOB_HP_POWER_SCALING_BASE * (double)((float)Math.pow(GameBalanceConfig.get().MOB_HP_POWER_SCALING, unitdata.getLevel())));
        stats.add(ExactStatData.noScaling(hp, ModType.MORE, Health.getInstance().GUID()));
        stats.add(ExactStatData.noScaling(expo, ModType.MORE, Health.getInstance().GUID()));
        stats.add(ExactStatData.noScaling(dmg, ModType.FLAT, OffenseStats.TOTAL_DAMAGE.get().GUID()));
        stats.add(ExactStatData.noScaling(stat, ModType.MORE, DodgeRating.getInstance().GUID()));
        stats.add(ExactStatData.noScaling(stat, ModType.MORE, Armor.getInstance().GUID()));
        for (Elements ele : Elements.getAllSingle()) {
            if (ele == Elements.Physical) continue;
            stats.add(ExactStatData.noScaling(stat, ModType.MORE, new ElementalResist(ele).GUID()));
        }
        stats.add(ExactStatData.noScaling(stat, ModType.MORE, Health.getInstance().GUID()));
        list.add(new MiscStatCtx(stats));
        return list;
    }

    public static List<StatContext> getMobBaseStats(EntityData unitdata, LivingEntity en) {
        ArrayList<StatContext> list = new ArrayList<StatContext>();
        ArrayList<ExactStatData> stats = new ArrayList<ExactStatData>();
        MobRarity rar = unitdata.getMobRarity();
        int lvl = unitdata.getLevel();
        float vanillahp = 0.0f;
        vanillahp = EntityUtils.getVanillaMaxHealth((LivingEntity)en);
        if (rar.forcesCustomHp()) {
            vanillahp = rar.force_custom_hp;
        }
        float hpToAdd = vanillahp * rar.ExtraHealthMulti();
        if ((hpToAdd = (float)((double)hpToAdd + (Double)ServerContainer.get().EXTRA_MOB_STATS_PER_LEVEL.get() * (double)lvl * (double)hpToAdd)) < 0.0f) {
            hpToAdd = 0.0f;
        }
        stats.add(ExactStatData.scaleTo(hpToAdd, ModType.FLAT, Health.getInstance().GUID(), lvl));
        stats.add(ExactStatData.scaleTo(0.5f, ModType.FLAT, HealthRegen.getInstance().GUID(), lvl));
        stats.add(ExactStatData.scaleTo(1.0f, ModType.FLAT, OffenseStats.ACCURACY.get().GUID(), lvl));
        stats.add(ExactStatData.scaleTo(10.0f * rar.StatMultiplier(), ModType.FLAT, Armor.getInstance().GUID(), lvl));
        for (Elements ele : Elements.getAllSingle()) {
            if (ele == Elements.Physical) continue;
            stats.add(ExactStatData.noScaling(10.0f * rar.StatMultiplier(), ModType.FLAT, new ElementalResist(ele).GUID()));
        }
        list.add(new MiscStatCtx(stats));
        return list;
    }
}

