/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.levels;

import com.robertx22.library_of_exile.tooltip.ExileTooltipUtils;
import com.robertx22.mine_and_slash.database.data.MinMax;
import com.robertx22.mine_and_slash.uncommon.levels.LevelChangeData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class LevelInfo {
    private int level = 1;
    public List<LevelChangeData> changes = new ArrayList<LevelChangeData>();

    public int getLevel() {
        return this.level;
    }

    public Component getTooltip() {
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        int last = -1;
        for (LevelChangeData change : this.changes) {
            if (last < 0) {
                last = 0;
            }
            boolean changed = last != change.levelAfterChange;
            last = change.levelAfterChange;
            String changedtext = changed ? "" : " - Didn't Change";
            list.add(Component.m_237113_((String)(change.change.name() + " " + change.source.name() + "\nLevel after Change: " + change.levelAfterChange + changedtext)));
        }
        list.add(Component.m_237113_((String)("Final Level: " + this.level)));
        return ExileTooltipUtils.joinMutableComps(list.listIterator(), (MutableComponent)Component.m_237113_((String)"\n"));
    }

    public void set(LevelSource source, int num) {
        LevelChangeData data = new LevelChangeData(num, ChangeType.SET, source);
        this.changes.add(data);
        this.level = data.levelAfterChange;
    }

    public void capToRange(LevelSource source, MinMax range) {
        LevelChangeData data = new LevelChangeData(range.capNumber(this.level), ChangeType.LEVEL_CAPPED_TO_RANGE, source);
        this.changes.add(data);
        this.level = data.levelAfterChange;
    }

    public void add(LevelSource source, int lvls) {
        LevelChangeData data = new LevelChangeData(this.level + lvls, ChangeType.BONUS_LEVELS, source);
        this.changes.add(data);
        this.level = data.levelAfterChange;
    }

    public static enum ChangeType {
        SET,
        LEVEL_CAPPED_TO_RANGE,
        BONUS_LEVELS;

    }

    public static enum LevelSource {
        ENTITY_CONFIG,
        MAP_DIMENSION,
        LEVEL_VARIANCE,
        DISTANCE_FROM_SPAWN,
        DIMENSION,
        MIN_LEVEL_AREA,
        NEAREST_PLAYER,
        NEAREST_PLAYER_CONFIG,
        MAX_LEVEL,
        BIOME;

    }
}

