/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.interfaces.data_items;

import com.robertx22.library_of_exile.utils.AllItemStackSavers;
import com.robertx22.library_of_exile.utils.ItemstackDataSaver;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.itemstack.CustomItemData;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.StackKeys;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ITooltip;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.IRarity;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ISalvagable;
import net.minecraft.world.item.ItemStack;

public interface ICommonDataItem<R extends Rarity>
extends ISalvagable,
ITooltip,
IRarity {
    @Override
    default public boolean isSalvagable(ExileStack stack) {
        return stack.get(StackKeys.CUSTOM).getOrCreate().data.get(CustomItemData.KEYS.SALVAGING_DISABLED) == false;
    }

    public int getLevel();

    default public int getSalvageExpReward() {
        GearRarity rar = this.getRarity();
        return (int)(30.0f * rar.item_tier_power * (float)this.getLevel());
    }

    default public int getAutoSalvageExpReward() {
        GearRarity rar = this.getRarity();
        return (int)(3.0f * rar.item_tier_power * (float)this.getLevel());
    }

    public ItemstackDataSaver<? extends ICommonDataItem> getStackSaver();

    public void saveToStack(ItemStack var1);

    public static ICommonDataItem load(ItemStack stack) {
        for (ItemstackDataSaver saver : AllItemStackSavers.getAllOfClass(ICommonDataItem.class)) {
            ICommonDataItem data = (ICommonDataItem)saver.loadFrom(stack);
            if (data == null) continue;
            return data;
        }
        return null;
    }
}

