/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.enumclasses;

import java.util.Locale;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public enum ModType {
    FLAT(false, "flat", AttributeModifier.Operation.ADDITION),
    PERCENT(true, "percent", AttributeModifier.Operation.MULTIPLY_BASE),
    MORE(true, "more", AttributeModifier.Operation.MULTIPLY_TOTAL);

    boolean isPercent;
    public AttributeModifier.Operation operation;
    public String id;

    private ModType(boolean isperc, String id, AttributeModifier.Operation op) {
        this.id = id;
        this.isPercent = isperc;
        this.operation = op;
    }

    public boolean isFlat() {
        return !this.isPercent;
    }

    public boolean isPercent() {
        return this.isPercent;
    }

    public static ModType fromString(String str) {
        for (ModType type : ModType.values()) {
            if (!type.id.toLowerCase(Locale.ROOT).equals(str.toLowerCase(Locale.ROOT))) continue;
            return type;
        }
        try {
            ModType TYPE2 = ModType.valueOf(str);
            if (TYPE2 != null) {
                return TYPE2;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return FLAT;
    }
}

