/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.effectdatas.rework.action;

import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.PositionSource;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.action.StatEffect;
import com.robertx22.mine_and_slash.uncommon.interfaces.EffectSides;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ProcSpellEffect
extends StatEffect {
    String spellId = "";
    PositionSource pos = PositionSource.TARGET;
    EffectSides source = EffectSides.Source;
    EffectSides target = EffectSides.Target;
    public boolean use_resource_costs = true;

    public ProcSpellEffect(String spellId, PositionSource pos) {
        super("proc_spell_" + spellId, "proc_spell");
        this.spellId = spellId;
        this.pos = pos;
    }

    ProcSpellEffect() {
        super("", "proc_spell");
    }

    @Override
    public void activate(EffectEvent event, EffectSides statSource, StatData data, Stat stat) {
        LivingEntity SO = event.getSide(this.source);
        LivingEntity TA = event.getSide(this.target);
        Spell spell = (Spell)ExileDB.Spells().get(this.spellId);
        SpellCastContext ctx = new SpellCastContext(SO, 0, spell);
        EntityData unit = Load.Unit((Entity)SO);
        if (this.use_resource_costs) {
            if (!unit.getResources().hasEnough(spell.getManaCostCtx(ctx))) {
                return;
            }
            if (!unit.getResources().hasEnough(spell.getEnergyCostCtx(ctx))) {
                return;
            }
            spell.spendResources(ctx);
        }
        SpellCtx c = SpellCtx.onCast(SO, ctx.calcData);
        c.setPositionSource(this.pos);
        c.target = TA;
        if (Load.Unit((Entity)event.source).getCooldowns().isOnCooldown(spell.GUID())) {
            return;
        }
        LivingEntity livingEntity = event.source;
        if (livingEntity instanceof Player) {
            Player p = (Player)livingEntity;
            Load.player((Player)p).spellCastingData.setCooldownOnCasted(ctx);
        } else {
            Load.Unit((Entity)event.source).getCooldowns().setOnCooldown(spell.GUID(), spell.getCooldownTicks(ctx));
        }
        spell.attached.onCast(c);
    }

    @Override
    public Class<? extends StatEffect> getSerClass() {
        return ProcSpellEffect.class;
    }
}

