/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.effectdatas.rework.action;

import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.saveclasses.unit.ResourceType;
import com.robertx22.mine_and_slash.saveclasses.unit.ResourcesData;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.action.StatEffect;
import com.robertx22.mine_and_slash.uncommon.interfaces.EffectSides;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class MissingResourceScalingEffect
extends StatEffect {
    public ResourceType resourceType = ResourceType.mana;
    public EffectSides side = EffectSides.Source;
    public float scalingPer = 1.0f;

    public MissingResourceScalingEffect(String id, ResourceType resourceType, float scalingPer) {
        super(id, "missing_resource_scaling");
        this.resourceType = resourceType;
        this.scalingPer = scalingPer;
    }

    public MissingResourceScalingEffect() {
        super("", "missing_resource_scaling");
    }

    @Override
    public void activate(EffectEvent event, EffectSides statSource, StatData data, Stat stat) {
        LivingEntity entity;
        LivingEntity livingEntity = entity = statSource == EffectSides.Source ? event.source : event.target;
        if (entity == null) {
            return;
        }
        ResourcesData resources = Load.Unit((Entity)entity).getResources();
        float current = resources.get(entity, this.resourceType);
        float max = resources.getMax(entity, this.resourceType);
        if (max <= 0.0f) {
            return;
        }
        float missingPercent = (max - current) / max * 100.0f;
        if (missingPercent <= 0.0f) {
            return;
        }
        float statValue = data.getValue();
        float effectiveScaling = missingPercent / this.scalingPer * statValue;
        event.data.getNumber((String)EventData.NUMBER).number += effectiveScaling;
    }

    @Override
    public Class<? extends StatEffect> getSerClass() {
        return MissingResourceScalingEffect.class;
    }
}

