/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.effectdatas;

import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffect;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.spells.entities.CalculatedSpellData;
import com.robertx22.mine_and_slash.event_hooks.damage_hooks.util.AttackInformation;
import com.robertx22.mine_and_slash.saveclasses.unit.ResourceType;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.ExilePotionEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.GiveOrTake2;
import com.robertx22.mine_and_slash.uncommon.effectdatas.RestoreResourceEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.builders.DamageEventBuilder;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.RestoreType;
import com.robertx22.mine_and_slash.uncommon.enumclasses.AttackType;
import java.util.function.Consumer;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class EventBuilder<T extends EffectEvent> {
    protected T event;

    public static EventBuilder<ExilePotionEvent> ofEffect(@NotNull CalculatedSpellData calc, LivingEntity caster, LivingEntity target, int lvl, ExileEffect effect, GiveOrTake2 giveOrTake, int ticks, boolean infinite) {
        ExilePotionEvent event = new ExilePotionEvent(calc, lvl, effect, giveOrTake, caster, target, ticks, infinite);
        EventBuilder<ExilePotionEvent> b = new EventBuilder<ExilePotionEvent>();
        b.event = event;
        return b;
    }

    public static DamageEventBuilder ofSpellDamage(LivingEntity source, LivingEntity target, int dmg, Spell spell) {
        DamageEvent event = new DamageEvent(null, source, target, dmg);
        DamageEventBuilder b = new DamageEventBuilder();
        b.event = event;
        b.setupDamage(AttackType.hit, spell.getWeapon(source), spell.getConfig().getStyle());
        b.setSpell(spell);
        return b;
    }

    public static DamageEventBuilder ofDamage(AttackInformation data, LivingEntity source, LivingEntity target, float dmg) {
        DamageEvent event = new DamageEvent(data, source, target, dmg);
        DamageEventBuilder b = new DamageEventBuilder();
        b.event = event;
        return b;
    }

    public static DamageEventBuilder ofDamage(LivingEntity source, LivingEntity target, float dmg) {
        DamageEvent event = new DamageEvent(null, source, target, dmg);
        DamageEventBuilder b = new DamageEventBuilder();
        b.event = event;
        return b;
    }

    public static EventBuilder<RestoreResourceEvent> ofRestore(LivingEntity source, LivingEntity target, ResourceType resource, RestoreType restoreType, float amount) {
        RestoreResourceEvent event = new RestoreResourceEvent(amount, source, target);
        EventBuilder<RestoreResourceEvent> b = new EventBuilder<RestoreResourceEvent>();
        b.event = event;
        event.data.setString(EventData.RESOURCE_TYPE, resource.name());
        event.data.setString(EventData.RESTORE_TYPE, restoreType.name());
        return b;
    }

    public EventBuilder<T> setSpell(Spell spell) {
        ((EffectEvent)this.event).data.setString(EventData.SPELL, spell.GUID());
        return this;
    }

    public EventBuilder<T> setSpell(String spell) {
        ((EffectEvent)this.event).data.setString(EventData.SPELL, spell);
        return this;
    }

    public EventBuilder<T> set(Consumer<T> s) {
        s.accept(this.event);
        return this;
    }

    protected void buildCheck() {
    }

    public T build() {
        this.buildCheck();
        return this.event;
    }
}

