/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.effectdatas;

import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.capability.player.data.PlayerConfigData;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.test.DataPackStatEffect;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.test.DatapackStat;
import com.robertx22.mine_and_slash.database.data.stats.layers.StatLayer;
import com.robertx22.mine_and_slash.database.data.stats.layers.StatLayerData;
import com.robertx22.mine_and_slash.database.data.stats.priority.StatPriority;
import com.robertx22.mine_and_slash.database.data.stats.types.UnknownStat;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.saveclasses.unit.Unit;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.StatOrderTest;
import com.robertx22.mine_and_slash.uncommon.effectdatas.base.EffectWithCtx;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.EffectSides;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatEffect;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public abstract class EffectEvent
implements IGUID {
    public boolean disableActivation = false;
    public boolean calcSourceEffects = true;
    public boolean calcTargetEffects = true;
    public EntityData sourceData;
    public EntityData targetData;
    public LivingEntity source;
    public LivingEntity target;
    private boolean effectsCalculated = false;
    public EventData data = new EventData();
    private boolean activated = false;
    private HashMap<String, StatLayerData> layers = new HashMap();
    private List<MoreMultiData> moreMultis = new ArrayList<MoreMultiData>();
    private static EffectWithCtx CALC_LAYERS_EFFECT = new EffectWithCtx(new IStatEffect(){

        @Override
        public boolean worksOnEvent(EffectEvent ev) {
            return true;
        }

        @Override
        public EffectSides Side() {
            return EffectSides.Source;
        }

        @Override
        public StatPriority GetPriority() {
            return StatPriority.Damage.CALC_DAMAGE_LAYERS;
        }

        @Override
        public void TryModifyEffect(EffectEvent effect, EffectSides statSource, StatData data, Stat stat) {
            effect.calculateStatLayersAndMoreMultis();
        }
    }, EffectSides.Source, new StatData(new UnknownStat().GUID(), 1.0f, 1.0f));

    public abstract String getName();

    public List<MoreMultiData> getMoreMultis() {
        return this.moreMultis;
    }

    public void addMoreMulti(Stat stat, String number, float multi) {
        this.addMoreMulti(Component.m_237113_((String)"Stat: ").m_7220_((Component)stat.locName()), number, multi);
    }

    public void addMoreMulti(MutableComponent text, String number, float multi) {
        if (multi != 1.0f) {
            this.moreMultis.add(new MoreMultiData(text, multi, number));
        }
    }

    public StatLayerData getLayer(StatLayer layer, String number, EffectSides side) {
        String id = layer.GUID() + "_" + number;
        if (!this.layers.containsKey(id)) {
            StatLayerData data = new StatLayerData(layer.GUID(), number, 0.0f, side);
            this.layers.put(id, data);
        }
        return this.layers.get(id);
    }

    public StatLayerData getConversionLayer(StatLayer layer, Elements ele, String number, EffectSides side) {
        String id = layer.GUID() + "_" + number + "_" + ele.GUID();
        if (!this.layers.containsKey(id)) {
            StatLayerData data = new StatLayerData(layer.GUID(), number, 0.0f, side);
            this.layers.put(id, data);
        }
        return this.layers.get(id);
    }

    public EffectEvent(float num, LivingEntity source, LivingEntity target) {
        this(source, target);
        this.data.setupNumber(EventData.NUMBER, num);
    }

    public EffectEvent(LivingEntity source, LivingEntity target) {
        this.source = source;
        this.target = target;
        if (target != null && source != null) {
            this.targetData = Load.Unit((Entity)target);
            this.sourceData = Load.Unit((Entity)source);
        } else {
            this.data.setBoolean(EventData.CANCELED, true);
        }
    }

    public boolean isSpell() {
        return this.data.isSpellEffect();
    }

    public Spell getSpell() {
        return (Spell)ExileDB.Spells().get(this.data.getString(EventData.SPELL));
    }

    public Spell getSpellOrNull() {
        if (!this.isSpell()) {
            return null;
        }
        return (Spell)ExileDB.Spells().get(this.data.getString(EventData.SPELL));
    }

    public void initBeforeActivating() {
    }

    public boolean canWorkOnDeadTarget() {
        return false;
    }

    public void increaseByPercent(String num, float perc) {
        this.data.getNumber((String)num).number += this.data.getOriginalNumber((String)num).number * perc / 100.0f;
    }

    public void Activate() {
        if (!this.activated) {
            if (this.source.m_21224_() || this.target.m_21224_()) {
                // empty if block
            }
            this.initBeforeActivating();
            this.calculateEffects();
            this.data.freeze();
            if (!this.data.isCanceled()) {
                if (!this.disableActivation) {
                    this.activate();
                }
                this.activated = true;
            }
        }
    }

    public List<StatLayerData> getSortedLayers() {
        ArrayList<StatLayerData> all = new ArrayList<StatLayerData>();
        all.addAll(this.layers.values());
        all.sort(Comparator.comparingInt(x -> x.getLayer().priority));
        return all;
    }

    private void calculateStatLayersAndMoreMultis() {
        if (!this.layers.isEmpty()) {
            List<StatLayerData> all = this.getSortedLayers();
            for (StatLayerData layer : all) {
                layer.getLayer().action.apply(this, layer, layer.numberID);
            }
        }
        if (!this.moreMultis.isEmpty()) {
            for (MoreMultiData more : this.moreMultis) {
                this.data.getNumber((String)more.numberid).number *= more.multi;
            }
        }
    }

    public void calculateEffects() {
        if (this.source.m_9236_().f_46443_) {
            return;
        }
        if (!this.effectsCalculated) {
            this.effectsCalculated = true;
            if (this.target == null || this.data.isCanceled() || this.sourceData == null || this.targetData == null) {
                return;
            }
            if (this.data.isCanceled()) {
                return;
            }
            List<EffectWithCtx> effectsWithCtx = new ArrayList<EffectWithCtx>();
            if (this.calcSourceEffects) {
                effectsWithCtx = this.AddEffects(effectsWithCtx, this.sourceData, this.source, EffectSides.Source);
            }
            if (this.calcTargetEffects) {
                effectsWithCtx = this.AddEffects(effectsWithCtx, this.targetData, this.target, EffectSides.Target);
            }
            effectsWithCtx.add(CALC_LAYERS_EFFECT);
            effectsWithCtx.sort(EffectWithCtx.COMPARATOR);
            this.testEffectsAreOrderedCorrectly(effectsWithCtx);
            for (EffectWithCtx item : effectsWithCtx) {
                if (item.stat.isNotZero()) {
                    item.effect.TryModifyEffect(this, item.statSource, item.stat, item.stat.GetStat());
                    continue;
                }
                System.out.print("ERORR cant be zero! ");
            }
        }
    }

    public void testEffectsAreOrderedCorrectly(List<EffectWithCtx> sortedEffects) {
        LivingEntity livingEntity = this.source;
        if (livingEntity instanceof Player) {
            Player p = (Player)livingEntity;
            if (Load.player((Player)p).config.isConfigEnabled(PlayerConfigData.Config.STAT_ORDER_TEST)) {
                ArrayList<String> toremove = new ArrayList<String>();
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                int i = 0;
                for (EffectWithCtx sort : sortedEffects) {
                    map.put(sort.stat.GetStat().GUID(), i);
                    ++i;
                }
                for (StatOrderTest.FirstAndSecond test : StatOrderTest.getAll()) {
                    String id = test.test(map, this.source.m_9236_());
                    if (id.isEmpty()) continue;
                    toremove.add(id);
                }
                for (String s : toremove) {
                    StatOrderTest.removeTest(s);
                }
            }
        }
    }

    protected abstract void activate();

    public LivingEntity getSide(EffectSides side) {
        if (side == EffectSides.Source) {
            return this.source;
        }
        return this.target;
    }

    private List<EffectWithCtx> AddEffects(List<EffectWithCtx> effects, EntityData enData, LivingEntity en, EffectSides side) {
        if (enData == null) {
            return effects;
        }
        Unit un = enData.getUnit();
        if (side == EffectSides.Source && this.isSpell() && en instanceof Player) {
            Player p = (Player)en;
            if (this.getSpell() != null) {
                un = Load.player(p).getSpellUnitStats(this.getSpell());
            }
        }
        ArrayList list = new ArrayList();
        un.getStats().stats.values().forEach(data -> {
            if (data.isNotZero()) {
                Stat stat = data.GetStat();
                if (stat instanceof DatapackStat) {
                    DatapackStat d = (DatapackStat)stat;
                    for (DataPackStatEffect eff : d.effect) {
                        if (!eff.worksOnEvent(this) || !eff.Side().equals((Object)side)) continue;
                        effects.add(new EffectWithCtx(eff, side, (StatData)data));
                        list.add(data);
                    }
                } else {
                    IStatEffect effect = null;
                    if (stat.statEffect != null && stat.statEffect.Side().equals((Object)side) && stat.statEffect.worksOnEvent(this)) {
                        effect = stat.statEffect;
                    }
                    if (effect != null) {
                        effects.add(new EffectWithCtx(effect, side, (StatData)data));
                        list.add(data);
                    }
                }
            }
        });
        return effects;
    }

    public static class MoreMultiData {
        public MutableComponent text;
        public float multi = 1.0f;
        public String numberid = "";

        public MoreMultiData(MutableComponent text, float multi, String numberid) {
            this.text = text;
            this.multi = multi;
            this.numberid = numberid;
        }
    }
}

