/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.unit.stat_calc;

import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.capability.player.PlayerData;
import com.robertx22.mine_and_slash.capability.player.helper.GemInventoryHelper;
import com.robertx22.mine_and_slash.capability.player.helper.SocketedGem;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.stats.AddPerPercentOfOther;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.stats.AttributeStat;
import com.robertx22.mine_and_slash.database.data.stats.types.core_stats.base.ICoreStat;
import com.robertx22.mine_and_slash.gui.screens.stat_gui.StatCalcInfoData;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.skill_gem.SkillGemData;
import com.robertx22.mine_and_slash.saveclasses.unit.GearData;
import com.robertx22.mine_and_slash.saveclasses.unit.InCalcStatContainer;
import com.robertx22.mine_and_slash.saveclasses.unit.StatContainer;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.saveclasses.unit.Unit;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_calc.CtxStats;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_calc.InCalc;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.SimpleStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.interfaces.AddToAfterCalcEnd;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.Cached;
import com.robertx22.mine_and_slash.uncommon.stat_calculation.CommonStatUtils;
import com.robertx22.mine_and_slash.uncommon.stat_calculation.MobStatUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;

public class StatCalculation {
    public static List<StatContext> getStatsWithoutSuppGems(LivingEntity entity, EntityData data) {
        List<Object> statContexts = new ArrayList();
        statContexts = StatCalculation.collectStatsWithCtx(entity, data, data.equipmentCache.getGear());
        statContexts.removeIf(x -> x.stats.isEmpty());
        if (entity instanceof Player) {
            Player p = (Player)entity;
            PlayerData pd = Load.player(p);
            pd.ctxs = new StatCalcInfoData();
            for (StatContext statContext : statContexts) {
                if (!(statContext instanceof SimpleStatCtx)) continue;
                SimpleStatCtx s = (SimpleStatCtx)statContext;
                pd.ctxs.list.add(s);
            }
        }
        return statContexts;
    }

    public static void calc(Unit unit, List<StatContext> statsWithoutSuppGems, LivingEntity entity, Spell spell, int skillGem) {
        if (entity.m_9236_().f_46443_) {
            return;
        }
        EntityData data = Load.Unit((Entity)entity);
        unit.clearStats();
        ArrayList<StatContext> gemstats = new ArrayList<StatContext>();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            PlayerData playerData = Load.player(p);
            gemstats.addAll(StatCalculation.collectGemStats(p, data, playerData, skillGem));
            gemstats.addAll(StatCalculation.collectSpellStats(p, data, playerData, spell));
        }
        InCalcStatContainer statCalc = new InCalcStatContainer();
        ArrayList<StatContext> allstats = new ArrayList<StatContext>();
        allstats.addAll(gemstats);
        allstats.addAll(statsWithoutSuppGems);
        allstats.add(CtxStats.addStatCtxModifierStats(allstats));
        CtxStats sc = new CtxStats(allstats);
        sc.applyToInCalc(statCalc);
        InCalc incalc = new InCalc(unit);
        incalc.addVanillaHpToStats(entity, statCalc);
        incalc.modify(data, statCalc);
        unit.setStats(statCalc.calculate());
        HashMap<String, StatData> stats = new HashMap<String, StatData>(unit.getStats().stats);
        StatContainer copiedStats = unit.getStats().clone();
        for (Map.Entry<String, StatData> en2 : stats.entrySet()) {
            Stat stat = en2.getValue().GetStat();
            if (!(stat instanceof ICoreStat)) continue;
            ICoreStat aff = (ICoreStat)((Object)stat);
            aff.affectStats(data, en2.getValue(), statCalc);
        }
        unit.setStats(statCalc.calculate());
        copiedStats = unit.getStats().clone();
        List<Map.Entry> addToAfterCalcStats = stats.entrySet().stream().filter(en -> ((StatData)en.getValue()).GetStat() instanceof AddToAfterCalcEnd).sorted((a, b) -> {
            int n;
            int priorityA;
            Stat statA = ((StatData)a.getValue()).GetStat();
            Stat statB = ((StatData)b.getValue()).GetStat();
            if (statA instanceof AddPerPercentOfOther) {
                AddPerPercentOfOther addA = (AddPerPercentOfOther)statA;
                v0 = addA.priority;
            } else {
                v0 = priorityA = Integer.MAX_VALUE;
            }
            if (statB instanceof AddPerPercentOfOther) {
                AddPerPercentOfOther addB = (AddPerPercentOfOther)statB;
                n = addB.priority;
            } else {
                n = Integer.MAX_VALUE;
            }
            int priorityB = n;
            return Integer.compare(priorityA, priorityB);
        }).toList();
        int lastPriority = Integer.MIN_VALUE;
        for (Map.Entry en3 : addToAfterCalcStats) {
            int currentPriority;
            AddToAfterCalcEnd aff = (AddToAfterCalcEnd)((Object)((StatData)en3.getValue()).GetStat());
            if (aff instanceof AddPerPercentOfOther) {
                AddPerPercentOfOther addStat = (AddPerPercentOfOther)aff;
                v0 = addStat.priority;
            } else {
                v0 = currentPriority = Integer.MAX_VALUE;
            }
            if (currentPriority > lastPriority && lastPriority != Integer.MIN_VALUE) {
                copiedStats = unit.getStats().clone();
            }
            aff.affectStats(copiedStats, unit.getStats(), (StatData)en3.getValue());
            lastPriority = currentPriority;
        }
        for (StatData stat : unit.getStats().stats.values()) {
            stat.softCapStat(unit);
        }
        Cached.VANILLA_STAT_UIDS_TO_CLEAR_EVERY_STAT_CALC.forEach(x -> {
            AttributeInstance in = entity.m_21051_((Attribute)x.left);
            if (in != null && in.m_22111_((UUID)x.right) != null) {
                in.m_22120_((UUID)x.right);
            }
        });
        unit.getStats().stats.values().forEach(x -> {
            if (x.GetStat() instanceof AttributeStat) {
                AttributeStat stat = (AttributeStat)x.GetStat();
                stat.addToEntity(entity, (StatData)x);
            }
        });
    }

    private static List<StatContext> collectGemStats(Player p, EntityData data, PlayerData playerData, int skillGem) {
        ArrayList<StatContext> statContexts = new ArrayList<StatContext>();
        if (skillGem > -1 && skillGem <= GemInventoryHelper.MAX_SKILL_GEMS) {
            SocketedGem gem = playerData.getSkillGemInventory().getHotbarGem(skillGem);
            for (SkillGemData d : gem.getSupportDatas()) {
                if (d.getSupport() == null) continue;
                statContexts.add(new SimpleStatCtx(StatContext.StatCtxType.SUPPORT_GEM, d.getSupport().GetAllStats(data, d)));
            }
        }
        return statContexts;
    }

    private static List<StatContext> collectSpellStats(Player p, EntityData data, PlayerData playerData, Spell spell) {
        ArrayList<StatContext> statContexts = new ArrayList<StatContext>();
        if (spell != null) {
            Spell other;
            List<ExactStatData> stats2;
            List<ExactStatData> stats = spell.getStats(p);
            if (!stats.isEmpty()) {
                statContexts.add(new SimpleStatCtx(StatContext.StatCtxType.INNATE_SPELL, stats));
            }
            if (spell.config.usesSupportGemsFromAnotherSpell() && !(stats2 = (other = spell.config.getSpellUsedForSuppGems()).getStats(p)).isEmpty()) {
                statContexts.add(new SimpleStatCtx(StatContext.StatCtxType.INNATE_SPELL, stats2));
            }
        }
        return statContexts;
    }

    private static List<StatContext> collectStatsWithCtx(LivingEntity entity, EntityData data, List<GearData> gears) {
        ArrayList<StatContext> statContexts = new ArrayList<StatContext>();
        statContexts.addAll(CommonStatUtils.addExactCustomStats(entity));
        statContexts.add(data.equipmentCache.getStatusEffectStats());
        statContexts.addAll(StatCalculation.addGearStats(gears));
        statContexts.addAll(CommonStatUtils.addMapAffixStats(entity));
        statContexts.addAll(CommonStatUtils.addBaseStats(entity));
        if (entity instanceof Player) {
            StatContext omen;
            Player p = (Player)entity;
            statContexts.addAll(Load.player((Player)p).cachedStats.statContexts);
            statContexts.add(Load.player((Player)p).cachedStats.getStatCompatStats());
            if (Load.player((Player)p).cachedStats.enchantCompat != null) {
                statContexts.add(Load.player((Player)p).cachedStats.enchantCompat);
            }
            if ((omen = Load.player((Player)p).cachedStats.omenStats) != null) {
                statContexts.add(omen);
            }
        } else {
            statContexts.addAll(MobStatUtils.getMobBaseStats(data, entity));
            if (data.isSummon()) {
                statContexts.addAll(MobStatUtils.addSummonStats((TamableAnimal)entity));
            } else {
                statContexts.addAll(MobStatUtils.getAffixStats(entity));
                statContexts.addAll(MobStatUtils.getWorldMultiplierStats(entity));
                statContexts.addAll(MobStatUtils.addMapTierStats(entity));
                statContexts.addAll(MobStatUtils.getMobConfigStats(entity, data));
            }
        }
        return statContexts;
    }

    static List<StatContext> addGearStats(List<GearData> gears) {
        ArrayList<StatContext> ctxs = new ArrayList<StatContext>();
        gears.forEach(x -> ctxs.addAll(x.cachedStats));
        return ctxs;
    }
}

