/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.unit;

import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.database.data.rarities.MobRarity;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.blood.Blood;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.blood.BloodUser;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.energy.Energy;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.health.Health;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.magic_shield.MagicShield;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.mana.Mana;
import com.robertx22.mine_and_slash.database.data.stats.types.special.BattlemageUser;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.saveclasses.unit.StatContainer;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.vanilla_mc.packets.EfficientMobUnitPacket;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;

public class Unit {
    public static Unit EMPTY = new Unit();
    private StatContainer stats = new StatContainer();

    public void toNbt(CompoundTag main) {
        CompoundTag nbt = new CompoundTag();
        int i = 0;
        for (StatData stat : this.stats.stats.values()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("v", stat.getValue());
            tag.m_128350_("m", stat.getMoreStatTypeMulti());
            tag.m_128359_("i", stat.getId());
            nbt.m_128365_("" + i, (Tag)tag);
            ++i;
        }
        main.m_128365_("mmorpg_unit", (Tag)nbt);
        main.m_128405_("mmorpg_unit_sn", this.stats.stats.size());
    }

    public void fromNbt(CompoundTag main) {
        this.stats = new StatContainer();
        CompoundTag nbt = main.m_128469_("mmorpg_unit");
        int num = main.m_128451_("mmorpg_unit_sn");
        for (int i = 0; i < num; ++i) {
            CompoundTag tag = nbt.m_128469_("" + i);
            String id = tag.m_128461_("i");
            float val = tag.m_128457_("v");
            float mul = tag.m_128457_("m");
            StatData data = new StatData(id, val, mul);
            this.stats.stats.put(data.getId(), data);
        }
    }

    public boolean isBloodMage() {
        return this.getCalculatedStat(BloodUser.getInstance()).getValue() > 0.0f;
    }

    public boolean isBattlemage() {
        return this.getCalculatedStat(BattlemageUser.getInstance()).getValue() > 0.0f;
    }

    public void clearStats() {
        this.stats = new StatContainer();
    }

    public StatContainer getStats() {
        if (this.stats == null) {
            this.stats = new StatContainer();
        }
        return this.stats;
    }

    public void setStats(StatContainer c) {
        this.stats = c;
    }

    public StatData getCalculatedStat(Stat stat) {
        return this.getCalculatedStat(stat.GUID());
    }

    public StatData getCalculatedStat(String guid) {
        if (this.getStats().stats == null) {
            this.initStats();
        }
        return this.getStats().stats.getOrDefault(guid, new StatData(guid, 0.0f, 1.0f));
    }

    public void initStats() {
        this.getStats().stats = new HashMap();
    }

    public Health health() {
        return Health.getInstance();
    }

    public Mana mana() {
        return Mana.getInstance();
    }

    public StatData healthData() {
        try {
            return this.getCalculatedStat(Health.GUID);
        }
        catch (Exception exception) {
            return StatData.empty();
        }
    }

    public StatData bloodData() {
        try {
            return this.getCalculatedStat(Blood.GUID);
        }
        catch (Exception exception) {
            return StatData.empty();
        }
    }

    public StatData energyData() {
        try {
            return this.getCalculatedStat(Energy.GUID);
        }
        catch (Exception exception) {
            return StatData.empty();
        }
    }

    public StatData magicShieldData() {
        try {
            return this.getCalculatedStat(MagicShield.GUID);
        }
        catch (Exception exception) {
            return StatData.empty();
        }
    }

    public StatData manaData() {
        try {
            return this.getCalculatedStat(Mana.GUID);
        }
        catch (Exception exception) {
            return StatData.empty();
        }
    }

    public String randomRarity(int lvl, EntityData data) {
        if (!data.getRarity().equals("common") && ExileDB.MobRarities().isRegistered(data.getRarity())) {
            return data.getRarity();
        }
        List rarities = ExileDB.MobRarities().getList().stream().filter(x -> data.getLevel() >= x.minMobLevelForRandomSpawns() || data.getLevel() >= GameBalanceConfig.get().MAX_LEVEL).collect(Collectors.toList());
        if (rarities.isEmpty()) {
            rarities.add((MobRarity)ExileDB.MobRarities().get("common"));
        }
        MobRarity finalRarity = (MobRarity)RandomUtils.weightedRandom(rarities);
        return finalRarity.GUID();
    }

    public static boolean shouldSendUpdatePackets(LivingEntity en) {
        return (Boolean)ServerContainer.get().DONT_SYNC_DATA_OF_AMBIENT_MOBS.get() == false || en.m_6095_().m_20674_() != MobCategory.AMBIENT && en.m_6095_().m_20674_() != MobCategory.WATER_AMBIENT;
    }

    public static MyPacket getUpdatePacketFor(LivingEntity en, EntityData data) {
        return new EfficientMobUnitPacket((Entity)en, data);
    }
}

