/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.unit;

import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.energy.Energy;
import com.robertx22.mine_and_slash.saveclasses.unit.ResourceType;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpendResourceEvent;
import com.robertx22.mine_and_slash.uncommon.enumclasses.ModType;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.HealthUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ResourcesData {
    private float mana = 0.0f;
    private float magic_shield = 0.0f;
    private float energy = 0.0f;
    private float blood = 0.0f;

    public float getMana() {
        return this.mana;
    }

    public float getEnergy() {
        return this.energy;
    }

    public float getBlood() {
        return this.blood;
    }

    public float getMagicShield() {
        return this.magic_shield;
    }

    public void onTickBlock(Player player, int ticks) {
        if (player.m_21254_()) {
            float cost = Energy.getInstance().scale(ModType.FLAT, ((Double)ServerContainer.get().BLOCK_COST.get()).floatValue(), Load.Unit((Entity)player).getLevel());
            SpendResourceEvent event = new SpendResourceEvent((LivingEntity)player, null, ResourceType.energy, cost * (float)ticks);
            event.calculateEffects();
            event.Activate();
            this.cap((LivingEntity)player, ResourceType.energy);
        }
    }

    public float getModifiedValue(LivingEntity en, ResourceType type, Use use, float amount) {
        if (use == Use.RESTORE) {
            return this.get(en, type) + amount;
        }
        return this.get(en, type) - amount;
    }

    public float get(LivingEntity en, ResourceType type) {
        if (type == ResourceType.mana) {
            return this.mana;
        }
        if (type == ResourceType.blood) {
            return this.blood;
        }
        if (type == ResourceType.energy) {
            return this.energy;
        }
        if (type == ResourceType.magic_shield) {
            return this.magic_shield;
        }
        if (type == ResourceType.health) {
            return HealthUtils.getCurrentHealth(en);
        }
        return 0.0f;
    }

    public float getMax(LivingEntity en, ResourceType type) {
        EntityData data = Load.Unit((Entity)en);
        if (type == ResourceType.mana) {
            return data.getUnit().manaData().getValue();
        }
        if (type == ResourceType.blood) {
            return data.getUnit().bloodData().getValue();
        }
        if (type == ResourceType.energy) {
            return data.getUnit().energyData().getValue();
        }
        if (type == ResourceType.magic_shield) {
            return data.getUnit().magicShieldData().getValue();
        }
        if (type == ResourceType.health) {
            return HealthUtils.getMaxHealth(en);
        }
        return 0.0f;
    }

    public void spend(LivingEntity en, ResourceType type, float amount) {
        this.modify(en, Use.SPEND, type, amount);
    }

    public void restore(LivingEntity en, ResourceType type, float amount) {
        this.modify(en, Use.RESTORE, type, amount);
    }

    public void modify(LivingEntity en, Use use, ResourceType type, float amount) {
        if (amount == 0.0f) {
            return;
        }
        if (type == ResourceType.mana) {
            this.mana = this.getModifiedValue(en, type, use, amount);
        } else if (type == ResourceType.blood) {
            this.blood = this.getModifiedValue(en, type, use, amount);
        } else if (type == ResourceType.energy) {
            this.energy = this.getModifiedValue(en, type, use, amount);
        } else if (type == ResourceType.magic_shield) {
            this.magic_shield = this.getModifiedValue(en, type, use, amount);
        } else if (type == ResourceType.health && use == Use.RESTORE) {
            HealthUtils.heal(en, amount);
        }
        this.cap(en, type);
        this.sync(en);
    }

    private void cap(LivingEntity en, ResourceType type) {
        if (type == ResourceType.mana) {
            this.mana = Mth.m_14036_((float)this.mana, (float)0.0f, (float)Load.Unit((Entity)en).getMaximumResource(type));
        } else if (type == ResourceType.energy) {
            this.energy = Mth.m_14036_((float)this.energy, (float)0.0f, (float)Load.Unit((Entity)en).getMaximumResource(type));
        } else if (type == ResourceType.magic_shield) {
            this.magic_shield = Mth.m_14036_((float)this.magic_shield, (float)0.0f, (float)Load.Unit((Entity)en).getMaximumResource(type));
        } else if (type == ResourceType.blood) {
            this.blood = Mth.m_14036_((float)this.blood, (float)0.0f, (float)Load.Unit((Entity)en).getMaximumResource(type));
        }
    }

    public void capAll(LivingEntity en) {
        this.mana = Mth.m_14036_((float)this.mana, (float)0.0f, (float)Load.Unit((Entity)en).getMaximumResource(ResourceType.mana));
        this.energy = Mth.m_14036_((float)this.energy, (float)0.0f, (float)Load.Unit((Entity)en).getMaximumResource(ResourceType.energy));
        this.magic_shield = Mth.m_14036_((float)this.magic_shield, (float)0.0f, (float)Load.Unit((Entity)en).getMaximumResource(ResourceType.magic_shield));
        this.blood = Mth.m_14036_((float)this.blood, (float)0.0f, (float)Load.Unit((Entity)en).getMaximumResource(ResourceType.blood));
    }

    private void sync(LivingEntity en) {
        if (en instanceof ServerPlayer) {
            Load.Unit((Entity)en).sync.setDirty();
        }
    }

    public boolean hasEnough(SpendResourceEvent ctx) {
        if (ctx.data.getNumber() <= 0.0f) {
            return true;
        }
        return this.get(ctx.target, ctx.data.getResourceType()) >= ctx.data.getNumber();
    }

    private static enum Use {
        SPEND,
        RESTORE;

    }
}

