/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.spells;

import com.robertx22.library_of_exile.events.base.ExileEvent;
import com.robertx22.library_of_exile.util.ExplainedResult;
import com.robertx22.mine_and_slash.database.OptScaleExactStat;
import com.robertx22.mine_and_slash.database.data.game_balance_config.PlayerPointsType;
import com.robertx22.mine_and_slash.database.data.perks.Perk;
import com.robertx22.mine_and_slash.database.data.spell_school.SpellSchool;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.events.MineAndSlashEvents;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.SimpleStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.uncommon.ExplainedResultUtil;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SpellSchoolsData
implements IStatCtx {
    public HashMap<String, Integer> allocated_lvls = new HashMap();

    public Set<String> school() {
        HashSet<String> list = new HashSet<String>();
        for (Perk perk : this.getAllPerks()) {
            Optional<SpellSchool> sc = perk.getSpellSchool();
            if (!sc.isPresent()) {
                this.allocated_lvls.remove(perk.GUID());
                continue;
            }
            list.add(sc.get().GUID());
        }
        return list;
    }

    public void removeUnlearnedPerks(Player player) {
        for (Map.Entry<String, Integer> entry : this.allocated_lvls.entrySet()) {
            if (entry.getValue() >= 1) continue;
            MineAndSlashEvents.PERK_UNLEARNED_AND_REMOVED.callEvents((ExileEvent)new MineAndSlashEvents.OnPerkUnlearnedAndRemoved(player, entry.getKey()));
            this.allocated_lvls.remove(entry.getKey());
        }
    }

    public List<Perk> getAllPerks() {
        ArrayList<Perk> all = new ArrayList<Perk>();
        this.allocated_lvls.entrySet().forEach(x -> {
            if ((Integer)x.getValue() > 0) {
                all.add((Perk)ExileDB.Perks().get((String)x.getKey()));
            }
        });
        return all;
    }

    public void reset(PointType type, Player player) {
        Set<String> schools = this.school();
        for (Perk perk : this.getAllPerks()) {
            Optional<SpellSchool> sch = perk.getSpellSchool();
            if (sch.isPresent() && sch.get() != null && schools.contains(sch.get().GUID())) continue;
            this.allocated_lvls.remove(perk.GUID());
        }
        for (Perk perk : this.getAllPerks()) {
            if (type == PointType.SPELL && perk.isSpell()) {
                MineAndSlashEvents.PERK_UNLEARNED_AND_REMOVED.callEvents((ExileEvent)new MineAndSlashEvents.OnPerkUnlearnedAndRemoved(player, perk.GUID()));
                this.allocated_lvls.remove(perk.GUID());
            }
            if (type != PointType.PASSIVE || !perk.isPassive()) continue;
            this.allocated_lvls.remove(perk.GUID());
        }
        this.removeUnlearnedPerks(player);
    }

    public int getLevel(String id) {
        return this.allocated_lvls.getOrDefault(id, 0);
    }

    public int getSpentPoints(PointType type) {
        int total = 0;
        for (Map.Entry<String, Integer> en : this.allocated_lvls.entrySet()) {
            if (!type.is(en.getKey())) continue;
            total += en.getValue().intValue();
        }
        return total;
    }

    public ExplainedResult canLearn(Player en, SpellSchool school, Perk perk) {
        PointType type = perk.getPointType();
        if (type.getGeneralType().getFreePoints(en) < 1) {
            return ExplainedResult.failure((Component)Chats.NOT_ENOUGH_POINTS.locName().m_130940_(ChatFormatting.RED));
        }
        if (!school.isLevelEnoughFor((LivingEntity)en, perk)) {
            return ExplainedResult.failure((Component)ExplainedResultUtil.createErrorAndReason(Chats.LEARN_ERROR, Chats.TOO_LOW_LEVEL));
        }
        if (!school.isLevelEnoughForSpellLevelUp((LivingEntity)en, perk, this.getLevel(perk.GUID()))) {
            return ExplainedResult.failure((Component)Chats.TOO_LOW_LEVEL_TO_UPGRADE_SPELL.locName().m_130940_(ChatFormatting.RED));
        }
        if (this.school().size() > 1 && !this.school().contains(school.GUID())) {
            return ExplainedResult.failure((Component)Chats.MAX_2_CLASSES.locName().m_130940_(ChatFormatting.RED));
        }
        if (this.allocated_lvls.getOrDefault(perk.GUID(), 0) >= perk.getMaxLevel()) {
            return ExplainedResult.failure((Component)Chats.PERK_MAXED.locName().m_130940_(ChatFormatting.RED));
        }
        return ExplainedResult.success();
    }

    public boolean canUnlearn(Player en, SpellSchool school, Perk perk) {
        if (this.getLevel(perk.id) < 1) {
            return false;
        }
        return perk.getPointType().getGeneralType().hasResetPoints(en);
    }

    public void learn(Perk perk, SpellSchool school) {
        if (!this.school().contains(school.GUID())) {
            this.school().add(school.GUID());
        }
        int current = this.allocated_lvls.getOrDefault(perk.GUID(), 0);
        this.allocated_lvls.put(perk.GUID(), current + 1);
    }

    public void unlearn(Player player, Perk perk, SpellSchool school) {
        int current;
        if (!this.school().contains(school.GUID())) {
            this.school().add(school.GUID());
        }
        if ((current = this.allocated_lvls.getOrDefault(perk.GUID(), 0).intValue()) > 0) {
            perk.getPointType().getGeneralType().reduceResetPoints(player, 1);
            this.allocated_lvls.put(perk.GUID(), current - 1);
        }
        this.removeUnlearnedPerks(player);
    }

    @Override
    public List<StatContext> getStatAndContext(LivingEntity en) {
        ArrayList<ExactStatData> stats = new ArrayList<ExactStatData>();
        for (Map.Entry<String, Integer> s : this.allocated_lvls.entrySet()) {
            if (!ExileDB.Perks().isRegistered(s.getKey())) continue;
            for (OptScaleExactStat stat : ((Perk)ExileDB.Perks().get((String)s.getKey())).stats) {
                ExactStatData data = stat.toExactStat(Load.Unit((Entity)en).getLevel());
                data.percentIncrease = (s.getValue() - 1) * 100;
                data.increaseByAddedPercent();
                stats.add(data);
            }
        }
        return Arrays.asList(new SimpleStatCtx(StatContext.StatCtxType.PASSIVES, stats));
    }

    public static enum PointType {
        SPELL,
        PASSIVE;


        public PlayerPointsType getGeneralType() {
            return this == SPELL ? PlayerPointsType.SPELLS : PlayerPointsType.PASSIVES;
        }

        public boolean is(String perkid) {
            if (this == SPELL) {
                return ((Perk)ExileDB.Perks().get(perkid)).isSpell();
            }
            return !((Perk)ExileDB.Perks().get(perkid)).isSpell();
        }
    }
}

