/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.spells;

import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.Cached;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.player.Player;

public class ChargeData {
    private HashMap<String, List<CdData>> cds = new HashMap();
    static List<CdData> empty = new ArrayList<CdData>();

    public int getCurrentTicksChargingOf(String id) {
        if (this.cds.containsKey(id) && this.cds.get(id).size() > 0) {
            return this.cds.get((Object)id).get((int)0).ticks;
        }
        return 0;
    }

    public boolean hasCharge(String id) {
        return this.getCharges(id) > 0;
    }

    void add(String id, int cd) {
        this.addList(id);
        this.cds.get(id).add(new CdData(id, cd));
    }

    void addList(String id) {
        if (!this.cds.containsKey(id)) {
            this.cds.put(id, new ArrayList());
        }
    }

    public void spendCharge(Player player, Spell spell, int cd) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        String id = spell.config.charge_name;
        int fn = MathHelper.clamp(cd, 0, 100000);
        this.add(id, fn);
        Load.player((Player)player).playerDataSync.setDirty();
    }

    public int getCharges(String id) {
        int oncd = (int)this.cds.getOrDefault(id, empty).stream().count();
        if (!Cached.MAX_SPELL_CHARGES.containsKey(id)) {
            ExileLog.get().log("Spell has no charges possible or the max spell charges aren't cached!", new Object[0]);
        }
        int charges = Cached.MAX_SPELL_CHARGES.getOrDefault(id, 0);
        charges -= oncd;
        charges = MathHelper.clamp(charges, 0, 100);
        return charges;
    }

    public void addOneCharges() {
        for (Map.Entry<String, List<CdData>> en : this.cds.entrySet()) {
            if (en.getValue().size() <= 0) continue;
            en.getValue().remove(0);
        }
    }

    public void onTicks(Player player, int ticks) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        boolean sync = false;
        for (Map.Entry<String, List<CdData>> en : this.cds.entrySet()) {
            Iterator<CdData> iterator = en.getValue().iterator();
            while (iterator.hasNext()) {
                CdData cd;
                CdData cdData = cd = iterator.next();
                Integer.valueOf(cdData.ticks - ticks);
                cdData.ticks = cdData.ticks;
            }
            if (!en.getValue().removeIf(x -> x.ticks < 1)) continue;
            sync = true;
        }
        if (sync) {
            Load.player((Player)player).playerDataSync.setDirty();
        }
    }

    static class CdData {
        String id;
        Integer ticks;

        public CdData(String id, Integer ticks) {
            this.id = id;
            this.ticks = ticks;
        }
    }
}

