/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.skill_gem;

import com.robertx22.library_of_exile.utils.ItemstackDataSaver;
import com.robertx22.library_of_exile.wrappers.ExileText;
import com.robertx22.mine_and_slash.database.data.aura.AuraGem;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.support_gem.SupportGem;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.inv_gui.actions.auto_salvage.ToggleAutoSalvageRarity;
import com.robertx22.mine_and_slash.gui.texts.ExileTooltips;
import com.robertx22.mine_and_slash.gui.texts.textblocks.AdditionalBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.ClickToOpenGuiBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.RarityBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.RequirementBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.StatBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.dropblocks.DropLevelBlock;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.RarityItems;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.SkillGemsItems;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ModRange;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipContext;
import com.robertx22.mine_and_slash.saveclasses.skill_gem.ISkillGem;
import com.robertx22.mine_and_slash.saveclasses.skill_gem.MaxLinks;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.enumclasses.PlayStyle;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.localization.Gui;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SkillGemData
implements ICommonDataItem<GearRarity> {
    public String id = "";
    public SkillGemType type = SkillGemType.SKILL;
    public int perc = 0;
    public String rar = "common";
    private int links = 1;

    @Override
    public void BuildTooltip(TooltipContext ctx) {
    }

    @Override
    public List<ItemStack> getSalvageResult(ExileStack stack) {
        if (!this.isSalvagable(stack)) {
            return Arrays.asList(new ItemStack[0]);
        }
        int amount = 1;
        return Arrays.asList(new ItemStack((ItemLike)RarityItems.RARITY_STONE.getOrDefault(this.getRarity().GUID(), RarityItems.RARITY_STONE.get("common")).get(), amount));
    }

    @Override
    public ToggleAutoSalvageRarity.SalvageType getSalvageType() {
        return ToggleAutoSalvageRarity.SalvageType.SPELL;
    }

    @Override
    public String getSalvageConfigurationId() {
        return this.id;
    }

    @Override
    public int getLevel() {
        return 1;
    }

    @Override
    public ItemstackDataSaver<SkillGemData> getStackSaver() {
        return StackSaving.SKILL_GEM;
    }

    @Override
    public void saveToStack(ItemStack stack) {
        this.getStackSaver().saveTo(stack, (Object)this);
    }

    public void setLinks(int t) {
        this.links = t;
    }

    public int getFlatLinks() {
        return this.links;
    }

    public MaxLinks getMaxLinks(Player p) {
        int total = GameBalanceConfig.get().getTotalLinks(this.links, p);
        boolean cappedBySpelllvl = GameBalanceConfig.get().getTotalLinks(total + 1, p) > total;
        boolean cappedByLevel = !cappedBySpelllvl && total < 5;
        return new MaxLinks(total, cappedByLevel, cappedBySpelllvl);
    }

    @Override
    public String getRarityId() {
        return this.rar;
    }

    @Override
    public GearRarity getRarity() {
        return (GearRarity)ExileDB.GearRarities().get(this.rar);
    }

    public int getStatPercent() {
        return this.perc;
    }

    public Spell getSpell() {
        if (this.type == SkillGemType.SKILL) {
            return (Spell)ExileDB.Spells().get(this.id);
        }
        return null;
    }

    public boolean canPlayerWear(Player p) {
        int req = this.getGeneric().getRequiredLevel();
        return Load.Unit((Entity)p).getLevel() >= req;
    }

    public AuraGem getAura() {
        if (this.type == SkillGemType.AURA) {
            return (AuraGem)ExileDB.AuraGems().get(this.id);
        }
        return null;
    }

    public SupportGem getSupport() {
        if (this.type == SkillGemType.SUPPORT) {
            return (SupportGem)ExileDB.SupportGems().get(this.id);
        }
        return null;
    }

    public ISkillGem getGeneric() {
        if (this.getSupport() != null) {
            return this.getSupport();
        }
        if (this.getSpell() != null) {
            return this.getSpell();
        }
        if (this.getAura() != null) {
            return this.getAura();
        }
        return null;
    }

    public PlayStyle getStyle() {
        return this.getGeneric().getStyle();
    }

    private MutableComponent stars(Player p) {
        int slots = GameBalanceConfig.get().getTotalLinks(this.links, p);
        MutableComponent text = Gui.AVAILABLE_SUPPORT_SLOTS.locName(slots).m_130940_(ChatFormatting.DARK_PURPLE);
        if (this.links > slots) {
            int next = GameBalanceConfig.get().getNextLinkUpgradeLevel(Load.Unit((Entity)p).getLevel());
            text = text.m_7220_((Component)Words.CAPPED_BECAUSE_PLAYER_LEVEL.locName(next));
        }
        return text;
    }

    public List<Component> getTooltip(Player p) {
        ArrayList<MutableComponent> stats;
        ArrayList<Component> list = new ArrayList<Component>();
        GearRarity rar = this.getRarity();
        int req = this.getGeneric().getRequiredLevel();
        if (this.type == SkillGemType.SKILL) {
            Spell spell = this.getSpell();
            if (spell == null) {
                return list;
            }
            for (Component c : spell.GetTooltipString(new StatRangeInfo(ModRange.of(rar.stat_percents)))) {
                list.add(c);
            }
            list.add((Component)ExileText.emptyLine().get());
            list.add((Component)this.stars(p));
            return list;
        }
        ISkillGem generic = this.getGeneric();
        list.add((Component)generic.locName().m_130940_(rar.textFormatting()));
        list.add((Component)ExileText.emptyLine().get());
        ExileTooltips tip = new ExileTooltips();
        if (this.type == SkillGemType.SUPPORT) {
            SupportGem supp = this.getSupport();
            stats = new ArrayList<MutableComponent>();
            for (ExactStatData ex : supp.GetAllStats(Load.Unit((Entity)p), this)) {
                stats.addAll(ex.GetTooltipString());
            }
            tip.accept(new StatBlock(){

                @Override
                public List<? extends Component> getAvailableComponents() {
                    return stats;
                }
            });
            tip.accept(new AdditionalBlock((Component)Itemtips.SUPPORT_GEM_COST.locName((int)(supp.manaMulti * 100.0f)).m_130940_(ChatFormatting.RED)));
            if (supp.isOneOfAKind()) {
                tip.accept(new AdditionalBlock((Component)Itemtips.SUPPORT_GEM_ONLY_ONE.locName().m_130946_(supp.one_of_a_kind)));
            }
            tip.accept(new AdditionalBlock((Component)Itemtips.SUPPORT_GEM_EXPLANATION.locName().m_130940_(ChatFormatting.AQUA)));
            tip.accept(new DropLevelBlock(supp.min_lvl, GameBalanceConfig.get().MAX_LEVEL));
            tip.accept(new ClickToOpenGuiBlock());
        }
        if (this.type == SkillGemType.AURA) {
            AuraGem aura = this.getAura();
            stats = new ArrayList();
            for (ExactStatData ex : aura.GetAllStats(Load.Unit((Entity)p), this)) {
                stats.addAll(ex.GetTooltipString());
            }
            tip.accept(new StatBlock(){

                @Override
                public List<? extends Component> getAvailableComponents() {
                    return stats;
                }
            });
            tip.accept(new AdditionalBlock((Component)Itemtips.AURA_RESERVATION.locName().m_130946_("" + (int)(aura.reservation * 100.0f)).m_130940_(ChatFormatting.RED)));
            int spiritLeft = Load.player(p).getSkillGemInventory().getRemainingSpirit(p);
            tip.accept(new AdditionalBlock((Component)Itemtips.REMAINING_AURA_CAPACITY.locName().m_130946_("" + spiritLeft).m_130940_(ChatFormatting.AQUA)));
            tip.accept(new DropLevelBlock(aura.min_lvl, GameBalanceConfig.get().MAX_LEVEL));
            tip.accept(new AdditionalBlock((Component)Itemtips.AUGMENT_EXPLANATION.locName().m_130940_(ChatFormatting.AQUA)));
            tip.accept(new ClickToOpenGuiBlock());
        }
        if (req > 0) {
            tip.accept(new RequirementBlock().setLevelRequirement(req));
        }
        tip.accept(new RarityBlock(rar));
        list.addAll(tip.release());
        return list;
    }

    public Item getItem() {
        return SkillGemsItems.get(this);
    }

    public static enum SkillGemType {
        SKILL,
        SUPPORT,
        AURA;

    }
}

