/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts;

import com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.gear.ExtractSocketItemMod;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.SlotFamily;
import com.robertx22.mine_and_slash.database.data.gems.Gem;
import com.robertx22.mine_and_slash.database.data.runes.Rune;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.StackKeys;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatsContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class SocketData
implements IStatsContainer {
    public String g = "";
    public int p = 0;

    public boolean isEmpty() {
        return this.getGem() == null && this.getRune() == null;
    }

    public boolean isGem() {
        return this.getGem() != null;
    }

    public boolean is(ExtractSocketItemMod.SocketedType type) {
        return type.is(this);
    }

    public boolean isRune() {
        return this.getRune() != null;
    }

    public List<Component> GetTooltipString(StatRangeInfo info, ExileStack gear, boolean addplaceholder) {
        ArrayList<Component> list = new ArrayList<Component>();
        this.GetAllStats(gear).forEach(x -> {
            String placeholder = addplaceholder ? "[SOCKET_PLACEHOLDER]" : " ";
            for (MutableComponent m : x.GetTooltipString()) {
                list.add((Component)Component.m_237113_((String)placeholder).m_7220_((Component)m));
            }
        });
        if (list.isEmpty()) {
            list.add((Component)Component.m_237113_((String)"Socket Display Error"));
        }
        return list;
    }

    public Gem getGem() {
        if (ExileDB.Gems().isRegistered(this.g)) {
            return (Gem)ExileDB.Gems().get(this.g);
        }
        return null;
    }

    public Rune getRune() {
        if (ExileDB.Runes().isRegistered(this.g)) {
            return (Rune)ExileDB.Runes().get(this.g);
        }
        return null;
    }

    public ItemStack getOriginalItemStack() {
        if (this.isGem()) {
            return this.getGem().getItem().m_7968_();
        }
        if (this.isRune()) {
            return this.getRune().getItem().m_7968_();
        }
        return ItemStack.f_41583_;
    }

    @Override
    public List<ExactStatData> GetAllStats(ExileStack stack) {
        GearItemData gear = stack.get(StackKeys.GEAR).get();
        SlotFamily fam = gear.GetBaseGearType().family();
        ArrayList<ExactStatData> stats = new ArrayList<ExactStatData>();
        try {
            if (this.isGem()) {
                this.getGem().getFor(fam).forEach(x -> stats.add(x.toExactStat(gear.getLevel())));
            }
            if (this.isRune()) {
                this.getRune().getFor(fam).forEach(x -> stats.add(x.ToExactStat(this.p, gear.getLevel())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stats;
    }
}

