/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts;

import com.robertx22.mine_and_slash.database.data.affixes.Affix;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.StackKeys;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IGearPart;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IGearPartTooltip;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.AffixData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatWithContext;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class GearAffixesData
implements IGearPartTooltip {
    public List<AffixData> suf = new ArrayList<AffixData>();
    public List<AffixData> pre = new ArrayList<AffixData>();
    public List<AffixData> cor = new ArrayList<AffixData>();

    public boolean isCorrupted() {
        return !this.cor.isEmpty();
    }

    public List<TooltipStatWithContext> getSufStatsWithCtx(GearItemData gear, StatRangeInfo info) {
        ArrayList<TooltipStatWithContext> list = new ArrayList<TooltipStatWithContext>();
        this.suf.forEach(x -> list.addAll(x.getAllStatsWithCtx(gear.getLevel(), gear.getRarity())));
        return list;
    }

    public List<TooltipStatWithContext> getPreStatsWithCtx(GearItemData gear, StatRangeInfo info) {
        ArrayList<TooltipStatWithContext> list = new ArrayList<TooltipStatWithContext>();
        this.pre.forEach(x -> list.addAll(x.getAllStatsWithCtx(gear.getLevel(), gear.getRarity())));
        return list;
    }

    public List<TooltipStatWithContext> getCorStatsWithCtx(GearItemData gear, StatRangeInfo info) {
        ArrayList<TooltipStatWithContext> list = new ArrayList<TooltipStatWithContext>();
        this.cor.forEach(x -> list.addAll(x.getAllStatsWithCtx(gear.getLevel(), gear.getRarity())));
        return list;
    }

    @Override
    public List<Component> GetTooltipString(StatRangeInfo info, ExileStack stack) {
        ArrayList<Component> list = new ArrayList<Component>();
        GearItemData gear = stack.get(StackKeys.GEAR).get();
        if (!this.getCorStatsWithCtx(gear, info).isEmpty()) {
            TooltipUtils.addEmpty(list);
            list.add((Component)Itemtips.COR_STATS.locName().m_130940_(ChatFormatting.RED));
            this.getCorStatsWithCtx(gear, info).forEach(x -> list.addAll(x.GetTooltipString()));
            TooltipUtils.addEmpty(list);
        }
        ChatFormatting color = ChatFormatting.BLUE;
        if (!this.getPreStatsWithCtx(gear, info).isEmpty()) {
            TooltipUtils.addEmpty(list);
            list.add((Component)Itemtips.PREFIX_STATS.locName().m_130940_(color));
            this.getPreStatsWithCtx(gear, info).forEach(x -> list.addAll(x.GetTooltipString()));
            TooltipUtils.addEmpty(list);
        }
        if (!this.getSufStatsWithCtx(gear, info).isEmpty()) {
            TooltipUtils.addEmpty(list);
            list.add((Component)Itemtips.SUFFIX_STATS.locName().m_130940_(color));
            this.getSufStatsWithCtx(gear, info).forEach(x -> list.addAll(x.GetTooltipString()));
            TooltipUtils.addEmpty(list);
        }
        return list;
    }

    public int getMaxAffixesPerType(GearItemData gear) {
        int affixes = gear.getRarity().maximumOfOneAffixType();
        return affixes;
    }

    public void add(AffixData affix) {
        if (affix.ty.isSuffix()) {
            this.suf.add(affix);
        } else {
            this.pre.add(affix);
        }
    }

    public int getNumberOfPrefixes() {
        return this.pre.size();
    }

    public int getNumberOfSuffixes() {
        return this.suf.size();
    }

    public void randomize(GearItemData gear) {
        this.pre.clear();
        this.suf.clear();
        GearRarity rar = gear.getRarity();
        for (int i = 0; i < rar.maximumOfOneAffixType(); ++i) {
            AffixData suffix = new AffixData(Affix.AffixSlot.suffix);
            suffix.RerollFully(gear);
            this.suf.add(suffix);
            AffixData prefix = new AffixData(Affix.AffixSlot.prefix);
            prefix.RerollFully(gear);
            this.pre.add(prefix);
        }
        int minaffixes = rar.min_affixes;
        for (int affixesToGen = minaffixes - this.getNumberOfAffixes(); affixesToGen > 0; --affixesToGen) {
            this.addOneRandomAffix(gear);
        }
    }

    public void addOneRandomAffix(GearItemData gear) {
        if (this.getNumberOfPrefixes() > this.getNumberOfSuffixes()) {
            AffixData suffix = new AffixData(Affix.AffixSlot.suffix);
            suffix.RerollFully(gear);
            this.suf.add(suffix);
        } else {
            AffixData prefix = new AffixData(Affix.AffixSlot.prefix);
            prefix.RerollFully(gear);
            this.pre.add(prefix);
        }
    }

    public boolean hasSuffix() {
        return this.getNumberOfSuffixes() > 0;
    }

    public boolean hasPrefix() {
        return this.getNumberOfPrefixes() > 0;
    }

    public List<AffixData> getAllAffixesAndSockets() {
        ArrayList<AffixData> list = new ArrayList<AffixData>();
        list.addAll(this.pre);
        list.addAll(this.suf);
        list.addAll(this.cor);
        return list;
    }

    public List<AffixData> getPrefixesAndSuffixes() {
        ArrayList<AffixData> list = new ArrayList<AffixData>();
        list.addAll(this.pre);
        list.addAll(this.suf);
        return list;
    }

    public boolean containsAffix(Affix affix) {
        return this.containsAffix(affix.GUID());
    }

    public boolean containsAffix(String id) {
        return this.getAllAffixesAndSockets().stream().anyMatch(x -> x.id.equals(id));
    }

    public int getNumberOfAffixes() {
        return this.getNumberOfPrefixes() + this.getNumberOfSuffixes();
    }

    @Override
    public IGearPart.Part getPart() {
        return IGearPart.Part.AFFIX;
    }
}

