/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts;

import com.robertx22.mine_and_slash.database.data.MinMax;
import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.stats.tooltips.StatTooltipType;
import com.robertx22.mine_and_slash.database.data.stats.types.gear_base.IBaseStatModifier;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.StackKeys;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IGearPart;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IGearPartTooltip;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IRerollable;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatsContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ModRange;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatWithContext;
import com.robertx22.mine_and_slash.uncommon.enumclasses.ModType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;

public class BaseStatsData
implements IRerollable,
IStatsContainer,
IGearPartTooltip {
    public Integer p = 0;

    @Override
    public void RerollFully(GearItemData gear) {
        this.p = this.getMinMax(gear).random();
    }

    @Override
    public void RerollNumbers(GearItemData gear) {
        this.RerollFully(gear);
    }

    @Override
    public List<Component> GetTooltipString(StatRangeInfo info, ExileStack stack) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (info.hasShiftDown) {
            list.add((Component)Component.m_237113_((String)" "));
            for (TooltipStatWithContext c : this.getAllStatsWithCtx(stack)) {
                list.addAll(c.GetTooltipString());
            }
            return list;
        }
        GearItemData gear = stack.get(StackKeys.GEAR).get();
        List<ExactStatData> all = this.GetAllStats(stack);
        info.statTooltipType = StatTooltipType.BASE_LOCAL_STATS;
        list.add((Component)Component.m_237113_((String)" "));
        for (ExactStatData stat : all) {
            list.addAll(stat.GetTooltipString());
        }
        info.statTooltipType = StatTooltipType.NORMAL;
        return list;
    }

    @Override
    public boolean isBaseStats() {
        return true;
    }

    @Override
    public MinMax getMinMax(GearItemData gear) {
        return gear.getRarity().base_stat_percents;
    }

    public List<TooltipStatWithContext> getAllStatsWithCtx(ExileStack ex) {
        ArrayList<TooltipStatWithContext> list = new ArrayList<TooltipStatWithContext>();
        GearItemData gear = ex.get(StackKeys.GEAR).get();
        int p = this.p + gear.getQualityBaseStatsBonus(ex);
        int lvl = gear.lvl;
        gear.GetBaseGearType().baseStats().forEach(x -> {
            ExactStatData exact = x.ToExactStat(p, lvl);
            TooltipStatInfo confo = new TooltipStatInfo(exact, p, new StatRangeInfo(ModRange.of(this.getMinMax(gear))));
            list.add(new TooltipStatWithContext(confo, (StatMod)x, lvl));
        });
        return list;
    }

    @Override
    public List<ExactStatData> GetAllStats(ExileStack stack) {
        GearItemData gear = stack.get(StackKeys.GEAR).get();
        ArrayList<ExactStatData> baseStats = new ArrayList<ExactStatData>();
        int p = this.p + gear.getQualityBaseStatsBonus(stack);
        int lvl = gear.lvl;
        gear.GetBaseGearType().baseStats().forEach(x -> {
            ExactStatData exact = x.ToExactStat(p, lvl);
            baseStats.add(exact);
        });
        try {
            IBaseStatModifier mod;
            Object object;
            List<IStatsContainer> list = gear.GetAllStatContainersExceptBase();
            ArrayList<ExactStatData> allstats = new ArrayList<ExactStatData>();
            for (IStatsContainer cont : list) {
                allstats.addAll(cont.GetAllStats(stack));
            }
            allstats.removeIf(x -> !(x.getStat() instanceof IBaseStatModifier));
            for (ExactStatData affixStatData : allstats) {
                object = affixStatData.getStat();
                if (!(object instanceof IBaseStatModifier)) continue;
                mod = (IBaseStatModifier)object;
                for (ExactStatData baseStat : baseStats) {
                    if (!mod.canModifyBaseStat(baseStat.getStat()) || affixStatData.getType() != ModType.FLAT) continue;
                    baseStat.add(ExactStatData.noScaling(affixStatData.getValue(), ModType.FLAT, baseStat.getStatId()));
                }
            }
            for (ExactStatData affixStatData : allstats) {
                object = affixStatData.getStat();
                if (!(object instanceof IBaseStatModifier)) continue;
                mod = (IBaseStatModifier)object;
                for (ExactStatData baseStat : baseStats) {
                    if (!mod.canModifyBaseStat(baseStat.getStat()) || affixStatData.getType() != ModType.PERCENT) continue;
                    baseStat.percentIncrease = affixStatData.getValue();
                    baseStat.increaseByAddedPercent();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return baseStats;
    }

    @Override
    public IGearPart.Part getPart() {
        return IGearPart.Part.BASE_STATS;
    }
}

