/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts;

import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.registry.FilterListWrap;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.database.Weighted;
import com.robertx22.mine_and_slash.database.data.MinMax;
import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.affixes.Affix;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.StackKeys;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IRerollable;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatsContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ModRange;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatWithContext;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AffixData
implements IRerollable,
IStatsContainer {
    public Integer p = -1;
    public String id;
    public String rar = "common";
    public Affix.AffixSlot ty;

    public GearRarity getRarity() {
        return (GearRarity)ExileDB.GearRarities().get(this.rar);
    }

    public void upgradeRarity() {
        GearRarity r = this.getRarity();
        if (r.hasHigherRarity()) {
            this.rar = r.getHigherRarity().GUID();
        }
        this.RerollNumbers();
    }

    public void setMaxRarity() {
        GearRarity r = this.getRarity();
        if (r.hasHigherRarity()) {
            this.rar = r.getHigherRarity().GUID();
        }
        this.RerollNumbers();
    }

    public void downgradeRarity() {
        GearRarity r = this.getRarity();
        Optional<GearRarity> opt = ExileDB.GearRarities().getList().stream().filter(x -> x.getHigherRarity() == r).findAny();
        if (opt.isPresent()) {
            this.rar = opt.get().GUID();
        }
        this.RerollNumbers();
    }

    public MinMax getMinMax() {
        return this.getRarity().stat_percents;
    }

    public AffixData(Affix.AffixSlot type) {
        this.ty = type;
    }

    private AffixData() {
    }

    public boolean isEmpty() {
        return this.p < 0;
    }

    public Affix.AffixSlot getAffixType() {
        return this.ty;
    }

    public Affix getAffix() {
        return (Affix)ExileDB.Affixes().get(this.id);
    }

    @Override
    public void RerollNumbers(GearItemData gear) {
        this.RerollNumbers();
    }

    public void RerollNumbers() {
        MinMax minmax = this.getMinMax();
        this.p = minmax.random();
    }

    public final Affix BaseAffix() {
        return (Affix)ExileDB.Affixes().get(this.id);
    }

    public List<TooltipStatWithContext> getAllStatsWithCtx(int lvl, GearRarity rar) {
        ArrayList<TooltipStatWithContext> list = new ArrayList<TooltipStatWithContext>();
        this.BaseAffix().getStats().forEach(x -> {
            ExactStatData exact = x.ToExactStat(this.p, lvl);
            TooltipStatInfo confo = new TooltipStatInfo(exact, this.p, new StatRangeInfo(ModRange.of(this.getMinMax())));
            confo.affix_rarity = this.getRarity();
            list.add(new TooltipStatWithContext(confo, (StatMod)x, lvl));
        });
        return list;
    }

    public boolean isValid() {
        if (!ExileDB.Affixes().isRegistered(this.id)) {
            return false;
        }
        return !this.isEmpty();
    }

    @Override
    public List<ExactStatData> GetAllStats(ExileStack stack) {
        GearItemData gear = stack.get(StackKeys.GEAR).get();
        return this.GetAllStats(gear.getLevel());
    }

    public List<ExactStatData> GetAllStats(int lvl) {
        if (!this.isValid()) {
            return Arrays.asList(new ExactStatData[0]);
        }
        return this.BaseAffix().getStats().stream().map(x -> x.ToExactStat(this.p, lvl)).collect(Collectors.toList());
    }

    public void create(GearItemData gear, Affix suffix) {
        this.id = suffix.GUID();
        this.RerollNumbers(gear);
    }

    @Override
    public void RerollFully(GearItemData gear) {
        Affix affix = null;
        try {
            FilterListWrap list = ExileDB.Affixes().getFilterWrapped(x -> x.type == this.getAffixType() && gear.canGetAffix((Affix)x));
            if (list.list.isEmpty()) {
                ExileLog.get().warn("Gear Type: " + gear.gtype + " affixtype: " + this.ty.name(), new Object[0]);
            }
            affix = (Affix)list.random();
            this.randomizeTier(gear.getRarity());
        }
        catch (Exception e) {
            ExileLog.get().warn("Gear Type: " + gear.gtype + " affixtype: " + this.ty.name(), new Object[0]);
            e.printStackTrace();
        }
        this.create(gear, affix);
    }

    public void randomizeTier(GearRarity rar) {
        List<Weighted> list = ExileDB.GearRarities().getFilterWrapped((Predicate<GearRarity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$randomizeTier$4(com.robertx22.mine_and_slash.database.data.rarities.GearRarity com.robertx22.mine_and_slash.database.data.rarities.GearRarity ), (Lcom/robertx22/mine_and_slash/database/data/rarities/GearRarity;)Z)((GearRarity)rar)).list.stream().map(x -> new Weighted<GearRarity>((GearRarity)x, x.affix_rarity_weight)).toList();
        this.rar = ((GearRarity)((Weighted)RandomUtils.weightedRandom(list)).obj).GUID();
    }

    private static /* synthetic */ boolean lambda$randomizeTier$4(GearRarity rar, GearRarity x) {
        return !x.is_unique_item && rar.item_tier >= x.item_tier;
    }
}

