/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.prophecy;

import com.robertx22.addons.dungeon_realm.MnsLeagues;
import com.robertx22.library_of_exile.utils.SoundUtils;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.data.map_affix.MapAffix;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.maps.AffectedEntities;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.maps.MapItemData;
import com.robertx22.mine_and_slash.prophecy.ProphecyData;
import com.robertx22.mine_and_slash.prophecy.ProphecyGeneration;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.SimpleStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.uncommon.coins.Coin;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PlayerProphecies
implements IStatCtx {
    public List<ProphecyData> rewardOffers = new ArrayList<ProphecyData>();
    public List<String> affixOffers = new ArrayList<String>();
    public String mapid = "";
    public List<String> affixesTaken = new ArrayList<String>();
    public int numMobAffixesCanAdd = 0;

    public void clearIfNewMap(MapItemData map) {
        this.mapid = map.uuid;
        this.numMobAffixesCanAdd = 0;
        this.affixesTaken.clear();
        this.affixOffers.clear();
        this.rewardOffers.clear();
    }

    public void regenAffixOffers() {
        this.affixOffers.clear();
        for (int i = 0; i < 3; ++i) {
            MapAffix affix = (MapAffix)ExileDB.MapAffixes().getFilterWrapped(x -> x.req.equals(MnsLeagues.INSTANCE.PROPHECY.GUID()) && x.affected == AffectedEntities.Players && this.affixOffers.stream().map(a -> (MapAffix)ExileDB.MapAffixes().get(a)).allMatch(e -> !e.prophecy_type.equals(x.prophecy_type))).random();
            this.affixOffers.add(affix.GUID());
        }
    }

    public void regenerateNewOffers(Player p) {
        this.rewardOffers = new ArrayList<ProphecyData>();
        for (int i = 0; i < (Integer)ServerContainer.get().PROPHECY_OFFERS_PER_REROLL.get(); ++i) {
            this.rewardOffers.add(ProphecyGeneration.generate(p));
        }
    }

    public void tryAcceptReward(Player p, String uuid) {
        MapData map = Load.mapAt(p.m_9236_(), p.m_20183_());
        if (map == null) {
            p.m_213846_((Component)Chats.MUST_BE_IN_MAP_TO_ACCEPT_PROPHECY.locName().m_130940_(ChatFormatting.RED));
            return;
        }
        if (!WorldUtils.isMapWorldClass(p.m_9236_(), p.m_20183_()) || !map.map.uuid.equals(this.mapid)) {
            p.m_213846_((Component)Chats.MUST_BE_IN_MAP_TO_ACCEPT_PROPHECY.locName().m_130940_(ChatFormatting.RED));
            return;
        }
        ProphecyData data = this.rewardOffers.stream().filter(x -> x.uuid.equals(uuid)).findAny().get();
        if (data != null) {
            if (Coin.PROPHECY.getTotalFromInventory(p) < data.cost) {
                p.m_213846_((Component)Chats.NOT_ENOUGH_FAVOR_TO_BUY_PROPHECY.locName().m_130940_(ChatFormatting.RED));
                return;
            }
            Coin.PROPHECY.spend(p, data.cost);
            SoundUtils.playSound((Entity)p, (SoundEvent)SoundEvents.f_11871_);
            this.rewardOffers.removeIf(x -> x.uuid.equals(data.uuid));
            for (ItemStack stack : data.generateRewards(p)) {
                PlayerUtils.giveItem(stack, p);
            }
        }
    }

    @Override
    public List<StatContext> getStatAndContext(LivingEntity en) {
        ArrayList<ExactStatData> list = new ArrayList<ExactStatData>();
        WorldUtils.ifMapData(en.m_9236_(), en.m_20183_()).ifPresent(map -> {
            if (map != null && map.map.uuid.equals(this.mapid)) {
                for (String s : this.affixesTaken) {
                    list.addAll(((MapAffix)ExileDB.MapAffixes().get(s)).getStats(100, Load.Unit((Entity)en).getLevel()));
                }
            }
        });
        SimpleStatCtx ctx = new SimpleStatCtx(StatContext.StatCtxType.PROPHECY_CURSE, list);
        return Arrays.asList(ctx);
    }
}

