/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mmorpg.registers.common;

import com.robertx22.library_of_exile.deferred.RegObj;
import com.robertx22.mine_and_slash.capability.player.container.BackpackMenu;
import com.robertx22.mine_and_slash.capability.player.container.JewelsMenu;
import com.robertx22.mine_and_slash.capability.player.container.SkillGemsMenu;
import com.robertx22.mine_and_slash.capability.player.data.Backpacks;
import com.robertx22.mine_and_slash.database.data.profession.all.Professions;
import com.robertx22.mine_and_slash.database.data.profession.screen.CraftingStationMenu;
import com.robertx22.mine_and_slash.mmorpg.registers.deferred_wrapper.Def;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.extensions.IForgeMenuType;

public class SlashContainers {
    public static HashMap<String, RegObj<MenuType<CraftingStationMenu>>> STATIONS = new HashMap();
    public static HashMap<Backpacks.BackpackType, RegObj<MenuType<BackpackMenu>>> BACKPACK_TABS = new HashMap();
    public static RegObj<MenuType<SkillGemsMenu>> SKILL_GEMS = Def.container("runeword", () -> IForgeMenuType.create((x, y, z) -> new SkillGemsMenu(x, (Container)y)));
    public static RegObj<MenuType<JewelsMenu>> JEWEL = Def.container("jewel", () -> IForgeMenuType.create((id, pInv, buf) -> new JewelsMenu(id, pInv)));

    public static void init() {
        SlashContainers.addStation(Professions.SALVAGING, () -> IForgeMenuType.create((x, y, z) -> new CraftingStationMenu(Professions.SALVAGING, x, (Container)y)));
        SlashContainers.addStation(Professions.GEAR_CRAFTING, () -> IForgeMenuType.create((x, y, z) -> new CraftingStationMenu(Professions.GEAR_CRAFTING, x, (Container)y)));
        SlashContainers.addStation(Professions.ALCHEMY, () -> IForgeMenuType.create((x, y, z) -> new CraftingStationMenu(Professions.ALCHEMY, x, (Container)y)));
        SlashContainers.addStation(Professions.COOKING, () -> IForgeMenuType.create((x, y, z) -> new CraftingStationMenu(Professions.COOKING, x, (Container)y)));
        SlashContainers.addStation(Professions.INFUSING, () -> IForgeMenuType.create((x, y, z) -> new CraftingStationMenu(Professions.INFUSING, x, (Container)y)));
        SlashContainers.addBackpackTab(Backpacks.BackpackType.GEARS);
        SlashContainers.addBackpackTab(Backpacks.BackpackType.MAPS);
        SlashContainers.addBackpackTab(Backpacks.BackpackType.CURRENCY);
        SlashContainers.addBackpackTab(Backpacks.BackpackType.SKILL_GEMS);
        SlashContainers.addBackpackTab(Backpacks.BackpackType.PROFESSION);
    }

    static void addStation(String prof, Supplier<MenuType<CraftingStationMenu>> sup) {
        STATIONS.put(prof, Def.container(prof, sup));
    }

    static void addBackpackTab(Backpacks.BackpackType type, Supplier<MenuType<BackpackMenu>> sup) {
        BACKPACK_TABS.put(type, Def.container("backpack_" + type.id, sup));
    }

    static void addBackpackTab(Backpacks.BackpackType type) {
        SlashContainers.addBackpackTab(type, () -> IForgeMenuType.create((id, pInv, buf) -> new BackpackMenu(type, id, pInv)));
    }
}

