/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mixins;

import com.robertx22.mine_and_slash.aoe_data.database.stats.ResourceStats;
import com.robertx22.mine_and_slash.event_hooks.damage_hooks.LivingHurtUtils;
import com.robertx22.mine_and_slash.event_hooks.damage_hooks.util.DmgSourceUtils;
import com.robertx22.mine_and_slash.mixin_ducks.LivingEntityAccesor;
import com.robertx22.mine_and_slash.mixin_methods.CanEntityHavePotionMixin;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.HealthUtils;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
implements LivingEntityAccesor {
    @Unique
    private boolean mmorpg$amountAdjustedAtHealMethod = false;

    @Shadow
    protected abstract float m_6100_();

    @Shadow
    protected abstract void m_8034_();

    @Override
    @Invoker(value="blockedByShield")
    public abstract void myknockback(LivingEntity var1);

    @Override
    @Invoker(value="getHurtSound")
    public abstract SoundEvent myGetHurtSound(DamageSource var1);

    @Override
    @Invoker(value="getSoundVolume")
    public abstract float myGetHurtVolume();

    @Override
    @Invoker(value="getVoicePitch")
    public abstract float myGetHurtPitch();

    @ModifyVariable(method={"heal(F)V"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    public float adjustHealAmount(float amount, float arg) {
        LivingEntity en = (LivingEntity)this;
        if (en instanceof Player) {
            return HealthUtils.realToVanilla(en, amount);
        }
        this.mmorpg$amountAdjustedAtHealMethod = true;
        float multiplier = LivingEntityMixin.getHealStrengthMultiplier(en);
        return amount * (1.0f + multiplier / 100.0f);
    }

    @Inject(method={"heal(F)V"}, at={@At(value="TAIL")})
    public void afterHeal(float healAmount, CallbackInfo ci) {
        this.mmorpg$amountAdjustedAtHealMethod = false;
    }

    @ModifyVariable(method={"setHealth(F)V"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    public float adjustPositiveSetHealthAmount(float value) {
        if (this.mmorpg$amountAdjustedAtHealMethod) {
            return value;
        }
        LivingEntity en = (LivingEntity)this;
        if (en instanceof Player) {
            return value;
        }
        float oldHealth = en.m_21223_();
        float healthToGain = value - oldHealth;
        if (healthToGain <= 0.0f) {
            return value;
        }
        float multiplier = LivingEntityMixin.getHealStrengthMultiplier(en);
        return oldHealth + healthToGain * (1.0f + multiplier / 100.0f);
    }

    private static float getHealStrengthMultiplier(LivingEntity en) {
        float multiplier = Load.Unit((Entity)en).getUnit().getCalculatedStat(ResourceStats.HEAL_STRENGTH.get()).getValue();
        if (multiplier < -100.0f) {
            multiplier = -100.0f;
        }
        return multiplier;
    }

    @Inject(method={"getDamageAfterMagicAbsorb"}, at={@At(value="HEAD")}, cancellable=true)
    public void hookench(DamageSource source, float amount, CallbackInfoReturnable<Float> ci) {
        LivingEntity en = (LivingEntity)this;
        if (DmgSourceUtils.isMyDmgSource(source)) {
            ci.setReturnValue((Object)Float.valueOf(amount));
        }
    }

    @Inject(method={"getDamageAfterMagicAbsorb"}, at={@At(value="RETURN")}, cancellable=true)
    public void hookenchreturn(DamageSource source, float amount, CallbackInfoReturnable<Float> ci) {
        LivingEntity en = (LivingEntity)this;
        if (!source.m_269533_(DamageTypeTags.f_268490_)) {
            LivingHurtUtils.damageCurioItems(en, amount);
        }
        if (DmgSourceUtils.isMyDmgSource(source)) {
            ci.setReturnValue((Object)Float.valueOf(amount));
        }
    }

    @Inject(method={"getDamageAfterArmorAbsorb"}, at={@At(value="HEAD")}, cancellable=true)
    public void hookarmortodmg(DamageSource source, float amount, CallbackInfoReturnable<Float> ci) {
        LivingEntity en = (LivingEntity)this;
        if (DmgSourceUtils.isMyDmgSource(source)) {
            ci.setReturnValue((Object)Float.valueOf(amount));
        }
    }

    @Inject(method={"canBeAffected"}, at={@At(value="HEAD")}, cancellable=true)
    public void hook(MobEffectInstance effect, CallbackInfoReturnable<Boolean> ci) {
        try {
            LivingEntity en = (LivingEntity)this;
            CanEntityHavePotionMixin.hook(en, effect, ci);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

