/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.maps;

import com.google.common.collect.ImmutableMap;
import com.robertx22.dungeon_realm.item.DungeonItemMapData;
import com.robertx22.dungeon_realm.item.DungeonItemNbt;
import com.robertx22.dungeon_realm.tooltip.MapTooltip;
import com.robertx22.library_of_exile.utils.ItemstackDataSaver;
import com.robertx22.mine_and_slash.aoe_data.database.stats.OffenseStats;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.stats.types.generated.ElementalResist;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.health.Health;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.inv_gui.actions.auto_salvage.ToggleAutoSalvageRarity;
import com.robertx22.mine_and_slash.gui.texts.ExileTooltips;
import com.robertx22.mine_and_slash.gui.texts.IgnoreNullList;
import com.robertx22.mine_and_slash.gui.texts.textblocks.AdditionalBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.NameBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.OperationTipBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.RarityBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.RequirementBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.StatBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.WorksOnBlock;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.loot.blueprints.MapBlueprint;
import com.robertx22.mine_and_slash.maps.AffectedEntities;
import com.robertx22.mine_and_slash.maps.MapAffixData;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.RarityItems;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ModRange;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRequirement;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipContext;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.SimpleStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.ModType;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientOnly;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MapItemData
implements ICommonDataItem<GearRarity> {
    private static MapItemData empty;
    public int lvl = 1;
    public int tier = 0;
    public String rar = "common";
    public List<MapAffixData> affixes = new ArrayList<MapAffixData>();
    public String uuid = UUID.randomUUID().toString();

    public void setRarityAndRerollNeeded(GearRarity rar) {
        this.rar = rar.GUID();
        MapBlueprint.genAffixes(this, rar);
        this.tier = this.getRarity().map_tiers.random();
        this.uuid = UUID.randomUUID().toString();
    }

    public static MapItemData empty() {
        if (empty == null) {
            empty = new MapItemData();
        }
        return empty;
    }

    public StatRequirement getStatReq() {
        StatRequirement req = new StatRequirement();
        for (Elements ele : Elements.getAllSingle()) {
            if (ele == Elements.Physical) continue;
            ElementalResist stat = new ElementalResist(ele);
            int number = this.getRarity().map_resist_req;
            for (MapAffixData affix : this.affixes) {
                if (affix.getAffix() == null || affix.getAffix().map_resist != ele) continue;
                number += affix.getAffix().map_resist_bonus_needed;
            }
            if (number <= 0) continue;
            req.base_req.put(stat.GUID(), Float.valueOf(number));
        }
        return req;
    }

    public List<ExactStatData> getTierStats() {
        ArrayList<ExactStatData> stats = new ArrayList<ExactStatData>();
        stats.add(ExactStatData.noScaling((float)(GameBalanceConfig.get().HP_MOB_BONUS_PER_MAP_TIER * (double)this.tier * 100.0), ModType.MORE, Health.getInstance().GUID()));
        stats.add(ExactStatData.noScaling((float)(GameBalanceConfig.get().DMG_MOB_BONUS_PER_MAP_TIER * (double)this.tier * 100.0), ModType.MORE, OffenseStats.TOTAL_DAMAGE.get().GUID()));
        return stats;
    }

    public boolean isEmpty() {
        return this.equals(MapItemData.empty());
    }

    public float getBonusLootMulti() {
        return this.bonusFormula();
    }

    public float bonusFormula() {
        float tierBonus = (float)this.tier * 0.02f;
        return 1.0f + tierBonus;
    }

    public float getExpMulti() {
        return this.getRarity().map_xp_multi;
    }

    public List<MapAffixData> getAllAffixesThatAffect(AffectedEntities aff) {
        return this.affixes.stream().filter(x -> x.getAffix() != null && x.getAffix().affected == aff).collect(Collectors.toList());
    }

    public List<Component> getTooltip(ExileStack stack) {
        int min;
        int lvl = Load.Unit((Entity)ClientOnly.getPlayer()).getLevel();
        if (lvl < (min = ((Integer)ServerContainer.get().MIN_LEVEL_MAP_DROPS.get()).intValue())) {
            lvl = min;
        }
        final MapItemData thisMapItemData = this;
        final StatRangeInfo tooltipInfo = new StatRangeInfo(ModRange.of(this.getRarity().stat_percents));
        ExileTooltips tip = new ExileTooltips().accept(new NameBlock(Collections.singletonList(Component.m_237115_((String)"item.mmorpg.map")))).accept(new RequirementBlock().setLevelRequirement(lvl).setStatRequirement(this.getStatReq())).accept(new RarityBlock(this.getRarity())).accept(new StatBlock(){
            @Nonnull
            private final MapItemData mapItemData;
            private final ImmutableMap<AffectedEntities, MutableComponent> map;
            {
                this.mapItemData = thisMapItemData;
                this.map = ImmutableMap.of((Object)((Object)AffectedEntities.Mobs), (Object)Words.Mob_Affixes.locName(), (Object)((Object)AffectedEntities.Players), (Object)Words.Player_Affixes.locName(), (Object)((Object)AffectedEntities.All), (Object)Words.Affixes_Affecting_All.locName());
            }

            @Override
            public List<? extends Component> getAvailableComponents() {
                IgnoreNullList<MutableComponent> list = new IgnoreNullList<MutableComponent>();
                Stream.of(AffectedEntities.Mobs, AffectedEntities.Players, AffectedEntities.All).forEachOrdered(x -> this.getAffectedStatList((IgnoreNullList<Component>)list, tooltipInfo, (AffectedEntities)((Object)x)));
                list.add(Itemtips.TIER_INFLUENCE.locName().m_130940_(ChatFormatting.BLUE));
                this.mapItemData.getTierStats().forEach(exactStatData -> list.addAll(exactStatData.GetTooltipString()));
                return list;
            }

            private void getAffectedStatList(IgnoreNullList<Component> list, StatRangeInfo info, AffectedEntities target) {
                List<MutableComponent> list1 = Optional.of(target).map(this.mapItemData::getAllAffixesThatAffect).filter(x -> !x.isEmpty()).stream().flatMap(Collection::stream).map(x -> x.getAffix().getStats(x.p, this.mapItemData.getLevel())).flatMap(x -> x.stream().map(y -> y.GetTooltipString()).flatMap(Collection::stream)).sorted((s1, s2) -> {
                    Boolean s1IfLong = s1.getString().contains("\u25c6");
                    Boolean s2IfLong = s2.getString().contains("\u25c6");
                    return s1IfLong.compareTo(s2IfLong);
                }).filter(x -> Objects.nonNull(x) && !x.getString().isBlank()).toList();
                if (!list1.isEmpty()) {
                    list.add((Component)((MutableComponent)this.map.get((Object)target)).m_130940_(ChatFormatting.BLUE));
                    list.addAll(list1);
                    list.add(ExileTooltips.EMPTY_LINE);
                }
            }
        }).accept(new AdditionalBlock(() -> {
            ArrayList<MutableComponent> additional = new ArrayList<MutableComponent>();
            DungeonItemMapData dungeonData = (DungeonItemMapData)DungeonItemNbt.DUNGEON_MAP.loadFrom(stack.getStack());
            if (dungeonData != null) {
                additional.add(MapTooltip.MapLayoutName((String)dungeonData.dungeon));
                if (dungeonData.uber) {
                    additional.add(MapTooltip.MapHasUber());
                }
            }
            if (!tooltipInfo.shouldShowDescriptions()) {
                additional.add(Itemtips.Exp.locName(this.getBonusExpAmountInPercent()).m_130940_(ChatFormatting.GOLD));
                additional.add(Itemtips.Loot.locName(this.getBonusLootAmountInPercent()).m_130940_(ChatFormatting.GOLD));
                additional.add(TooltipUtils.tier(this.tier).m_130940_(ChatFormatting.GOLD));
            } else {
                additional.add(Itemtips.Exp.locName(this.getBonusExpAmountInPercent()).m_130940_(ChatFormatting.GOLD));
                additional.add(Itemtips.Loot.locName(this.getBonusLootAmountInPercent()).m_130940_(ChatFormatting.GOLD));
                additional.add(TooltipUtils.tier(this.tier).m_130940_(ChatFormatting.GOLD));
                additional.add(Component.m_237113_((String)("[" + Itemtips.SOUL_TIER_TIP.locName().getString() + "]")).m_130940_(ChatFormatting.BLUE));
            }
            return additional;
        })).accept(WorksOnBlock.possibleDrops(ExileDB.GearRarities().getFilterWrapped((Predicate<GearRarity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getTooltip$2(com.robertx22.mine_and_slash.database.data.rarities.GearRarity ), (Lcom/robertx22/mine_and_slash/database/data/rarities/GearRarity;)Z)((MapItemData)this)).list).notDraggable());
        tip.accept(new OperationTipBlock().setAlt());
        return tip.release();
    }

    @Override
    public void BuildTooltip(TooltipContext ctx) {
        if (ctx.data != null) {
            ctx.tooltip.clear();
            ctx.tooltip.addAll(this.getTooltip(ExileStack.of(ctx.stack)));
        }
    }

    private int getBonusLootAmountInPercent() {
        return (int)((this.getBonusLootMulti() - 1.0f) * 100.0f);
    }

    private int getBonusExpAmountInPercent() {
        int exp = (int)((this.getExpMulti() - 1.0f) * 100.0f);
        return exp;
    }

    public List<StatContext> getStatAndContext(LivingEntity en) {
        ArrayList<ExactStatData> stats = new ArrayList<ExactStatData>();
        try {
            for (MapAffixData affix : this.getAllAffixesThatAffect(AffectedEntities.of(en))) {
                stats.addAll(affix.getAffix().getStats(affix.p, this.getLevel()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Arrays.asList(new SimpleStatCtx(StatContext.StatCtxType.MOB_AFFIX, stats));
    }

    @Override
    public String getRarityId() {
        return this.rar;
    }

    @Override
    public GearRarity getRarity() {
        return (GearRarity)ExileDB.GearRarities().get(this.rar);
    }

    public int getTier() {
        return this.tier;
    }

    @Override
    public int getLevel() {
        return this.lvl;
    }

    @Override
    public ItemstackDataSaver<? extends ICommonDataItem> getStackSaver() {
        return StackSaving.MAP;
    }

    @Override
    public void saveToStack(ItemStack stack) {
        StackSaving.MAP.saveTo(stack, (Object)this);
    }

    @Override
    public List<ItemStack> getSalvageResult(ExileStack stack) {
        if (!this.isSalvagable(stack)) {
            return Arrays.asList(new ItemStack[0]);
        }
        int amount = 1;
        GearRarity mapRarity = this.getRarity();
        Optional<GearRarity> rareRarityOpt = ExileDB.GearRarities().getList().stream().filter(r -> r.item_tier == 2).findFirst();
        GearRarity stoneRarity = mapRarity.item_tier < 2 ? mapRarity : rareRarityOpt.orElse(mapRarity);
        return Arrays.asList(new ItemStack((ItemLike)RarityItems.RARITY_STONE.getOrDefault(stoneRarity.GUID(), RarityItems.RARITY_STONE.get("common")).get(), amount));
    }

    @Override
    public ToggleAutoSalvageRarity.SalvageType getSalvageType() {
        return ToggleAutoSalvageRarity.SalvageType.MAP;
    }

    private /* synthetic */ boolean lambda$getTooltip$2(GearRarity x) {
        return this.tier >= ((GearRarity)ExileDB.GearRarities().get((String)x.min_map_rarity_to_drop)).map_tiers.min;
    }
}

