/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.generators;

import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.MapBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.WatcherEyeBlueprint;
import com.robertx22.mine_and_slash.loot.generators.BaseLootGen;
import com.robertx22.mine_and_slash.uncommon.enumclasses.LootType;
import net.minecraft.world.item.ItemStack;

public class WatcherEyeLootGen
extends BaseLootGen<MapBlueprint> {
    public WatcherEyeLootGen(LootInfo info) {
        super(info);
    }

    @Override
    public float baseDropChance() {
        float chance = ((Double)ServerContainer.get().WATCHER_EYE_DROPRATE.get()).floatValue();
        return chance;
    }

    @Override
    public boolean chanceIsModified() {
        return false;
    }

    @Override
    public LootType lootType() {
        return LootType.WatcherEye;
    }

    @Override
    public boolean condition() {
        return this.info.mobData != null && this.info.mobData.getMobRarity().GUID().equals("uber");
    }

    @Override
    public boolean hasLevelDistancePunishment() {
        return false;
    }

    @Override
    public ItemStack generateOne() {
        WatcherEyeBlueprint b = new WatcherEyeBlueprint(this.info);
        return b.createStack();
    }
}

