/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.generators;

import com.robertx22.addons.orbs_of_crafting.currency.reworked.addon.ExtendedOrb;
import com.robertx22.library_of_exile.database.init.LibDatabase;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.ItemBlueprint;
import com.robertx22.mine_and_slash.loot.generators.BaseLootGen;
import com.robertx22.mine_and_slash.uncommon.enumclasses.LootType;
import com.robertx22.orbs_of_crafting.register.ExileCurrency;
import net.minecraft.world.item.ItemStack;

public class CurrencyLootGen
extends BaseLootGen<ItemBlueprint> {
    public CurrencyLootGen(LootInfo info) {
        super(info);
    }

    @Override
    public float baseDropChance() {
        float chance = ((Double)ServerContainer.get().CURRENCY_DROPRATE.get()).floatValue();
        return chance;
    }

    @Override
    public LootType lootType() {
        return LootType.Currency;
    }

    @Override
    public boolean condition() {
        return this.info.level > 5;
    }

    @Override
    public ItemStack generateOne() {
        ExileCurrency currency = (ExileCurrency)LibDatabase.Currency().getFilterWrapped(x -> {
            ExtendedOrb ext = ExtendedOrb.from(x);
            return ext == null || !ext.drop_req.hasLeague() || ext.drop_req.canDropInLeague(this.info.league, this.info.level);
        }).random();
        return currency.getItem().m_7968_();
    }
}

